/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.DoublePredicate;
import kala.collection.AnySet;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.ImmutableDoubleSet;
import kala.collection.primitive.DoubleCollection;
import kala.collection.primitive.DoubleSetLike;
import kala.collection.primitive.DoubleSetView;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.internal.view.DoubleSetViews;
import org.jetbrains.annotations.NotNull;

public interface DoubleSet
extends PrimitiveSet<Double>,
DoubleCollection,
DoubleSetLike {
    public static DoubleCollectionFactory<?, DoubleSet> factory() {
        return DoubleCollectionFactory.narrow(ImmutableDoubleSet.factory());
    }

    @NotNull
    public static DoubleSet empty() {
        return ImmutableDoubleSet.empty();
    }

    @NotNull
    public static DoubleSet of() {
        return ImmutableDoubleSet.of();
    }

    @NotNull
    public static DoubleSet of(double value1) {
        return ImmutableDoubleSet.of(value1);
    }

    @NotNull
    public static DoubleSet of(double value1, double value2) {
        return ImmutableDoubleSet.of(value1, value2);
    }

    @NotNull
    public static DoubleSet of(double value1, double value2, double value3) {
        return ImmutableDoubleSet.of(value1, value2, value3);
    }

    @NotNull
    public static DoubleSet of(double value1, double value2, double value3, double value4) {
        return ImmutableDoubleSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static DoubleSet of(double value1, double value2, double value3, double value4, double value5) {
        return ImmutableDoubleSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static DoubleSet of(double ... values) {
        return ImmutableDoubleSet.of(values);
    }

    @NotNull
    public static DoubleSet from(double @NotNull [] values) {
        return ImmutableDoubleSet.from(values);
    }

    @NotNull
    public static DoubleSet from(@NotNull DoubleTraversable values) {
        return ImmutableDoubleSet.from(values);
    }

    @NotNull
    public static DoubleSet from(@NotNull DoubleIterator it) {
        return ImmutableDoubleSet.from(it);
    }

    public static int hashCode(@NotNull DoubleSet set) {
        int h = 1045751549;
        DoubleIterator it = set.iterator();
        while (it.hasNext()) {
            h += Double.hashCode(it.nextDouble());
        }
        return h;
    }

    public static boolean equals(@NotNull DoubleSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof DoubleSet) {
            return set1.containsAll((DoubleSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Double && set1.contains((Double)v)) continue;
            return false;
        }
        return true;
    }

    default public boolean contains(double value) {
        return this.iterator().contains(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "DoubleSet";
    }

    @NotNull
    default public DoubleCollectionFactory<?, ? extends DoubleSet> iterableFactory() {
        return DoubleSet.factory();
    }

    @Override
    @NotNull
    default public DoubleSetView view() {
        return new DoubleSetViews.Of<DoubleSet>(this);
    }

    @Override
    @NotNull
    default public ImmutableDoubleSet filter(@NotNull DoublePredicate predicate) {
        return ImmutableDoubleSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableDoubleSet filterNot(@NotNull DoublePredicate predicate) {
        return ImmutableDoubleSet.from(this.view().filterNot(predicate));
    }
}

