/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.mutable.primitive.MutableFloatArrayList;
import kala.collection.primitive.FloatCollectionLike;
import kala.collection.primitive.FloatSeqIterator;
import kala.collection.primitive.FloatSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.FloatSeqIterators;
import kala.control.primitive.FloatOption;
import kala.function.FloatFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface FloatSeqLike
extends PrimitiveSeqLike<Float>,
FloatCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "FloatSeqLike";
    }

    @Override
    @NotNull
    public FloatSeqView view();

    @NotNull
    default public FloatIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return FloatIterator.empty();
            }
        }
        FloatIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextFloat();
        }
        return it;
    }

    @NotNull
    default public FloatSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public FloatSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new FloatSeqIterators.DefaultFloatSeqIterator<FloatSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public float elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public float get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextFloat();
    }

    @Contract(pure=true)
    @Nullable
    default public Float getOrNull(int index) {
        return this.isDefinedAt(index) ? Float.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public FloatOption getOption(int index) {
        return this.isDefinedAt(index) ? FloatOption.some((float)this.get(index)) : FloatOption.none();
    }

    @NotNull
    default public FloatIterator reverseIterator() {
        FloatIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableFloatArrayList builder = new MutableFloatArrayList();
        while (it.hasNext()) {
            builder.append(it.nextFloat());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public FloatOption find(@NotNull FloatPredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public FloatOption findFirst(@NotNull FloatPredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public FloatOption findLast(@NotNull FloatPredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public float first() {
        return this.iterator().nextFloat();
    }

    @Nullable
    default public Float firstOrNull() {
        return this.isNotEmpty() ? Float.valueOf(this.first()) : null;
    }

    @NotNull
    default public FloatOption firstOption() {
        return this.isNotEmpty() ? FloatOption.some((float)this.first()) : FloatOption.none();
    }

    default public float last() {
        return this.reverseIterator().nextFloat();
    }

    @Nullable
    default public Float lastOrNull() {
        return this.isNotEmpty() ? Float.valueOf(this.last()) : null;
    }

    @NotNull
    default public FloatOption lastOption() {
        return this.isNotEmpty() ? FloatOption.some((float)this.last()) : FloatOption.none();
    }

    default public float first(@NotNull FloatPredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Float firstOrNull(@NotNull FloatPredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public FloatOption firstOption(@NotNull FloatPredicate predicate) {
        return this.findFirst(predicate);
    }

    default public float last(@NotNull FloatPredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Float lastOrNull(@NotNull FloatPredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public FloatOption lastOption(@NotNull FloatPredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(float value) {
        int idx = 0;
        FloatIterator it = this.iterator();
        while (it.hasNext()) {
            if (Float.floatToIntBits(value) == Float.floatToIntBits(it.nextFloat())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(float value, int from) {
        int idx = 0;
        FloatIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && Float.floatToIntBits(value) == Float.floatToIntBits(it.nextFloat())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull FloatPredicate predicate) {
        int idx = 0;
        FloatIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextFloat())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull FloatPredicate predicate, int from) {
        int idx = 0;
        FloatIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextFloat())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(float value) {
        int idx = this.size() - 1;
        FloatIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (Float.floatToIntBits(value) == Float.floatToIntBits(it.nextFloat())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(float value, int end) {
        int idx = this.size() - 1;
        FloatIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && Float.floatToIntBits(value) == Float.floatToIntBits(it.nextFloat())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull FloatPredicate predicate) {
        int idx = this.size() - 1;
        FloatIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextFloat())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull FloatPredicate predicate, int end) {
        int idx = this.size() - 1;
        FloatIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextFloat())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike dropWhile(@NotNull FloatPredicate var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike take(int var1);

    @NotNull
    public FloatSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike takeWhile(@NotNull FloatPredicate var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike updated(int var1, float var2);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike concat(@NotNull FloatSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike prepended(float var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike prependedAll(float @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike prependedAll(@NotNull FloatTraversable var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike appended(float var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike appendedAll(@NotNull FloatTraversable var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike appendedAll(float @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public FloatSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public FloatSeqLike filter(@NotNull FloatPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public FloatSeqLike filterNot(@NotNull FloatPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public FloatSeqLike map(@NotNull FloatUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull FloatFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public FloatSeqLike flatMap(@NotNull FloatFunction<? extends FloatTraversable> var1);

    @NotNull
    public <T> SeqLike<T> flatMapToObj(@NotNull FloatFunction<? extends Iterable<? extends T>> var1);
}

