/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.immutable.primitive.ImmutableFloatSeq;
import kala.collection.primitive.FloatArraySeq;
import kala.collection.primitive.FloatCollectionView;
import kala.collection.primitive.FloatSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.FloatSeqViews;
import kala.function.FloatFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface FloatSeqView
extends FloatSeqLike,
FloatCollectionView,
PrimitiveSeqView<Float> {
    @NotNull
    public static FloatSeqView empty() {
        return FloatSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "FloatSeqView";
    }

    @Override
    @NotNull
    default public FloatSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return FloatSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new FloatSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return FloatSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return FloatSeqView.empty();
        }
        return new FloatSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return FloatSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return FloatSeqView.empty();
        }
        return new FloatSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView dropWhile(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new FloatSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return FloatSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return FloatSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new FloatSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public FloatSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return FloatSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return FloatSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new FloatSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView takeWhile(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new FloatSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView updated(int index, float newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new FloatSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView concat(@NotNull FloatSeqLike other) {
        Objects.requireNonNull(other);
        return new FloatSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView prepended(float value) {
        return new FloatSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView prependedAll(float @NotNull [] values) {
        Objects.requireNonNull(values);
        return new FloatSeqViews.Concat(FloatArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView prependedAll(@NotNull FloatTraversable values) {
        Objects.requireNonNull(values);
        return new FloatSeqViews.Concat(values instanceof FloatSeqLike ? (FloatSeqLike)values : ImmutableFloatSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView appended(float value) {
        return new FloatSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView appendedAll(float @NotNull [] values) {
        Objects.requireNonNull(values);
        return new FloatSeqViews.Concat(this, FloatArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView appendedAll(@NotNull FloatTraversable values) {
        Objects.requireNonNull(values);
        return new FloatSeqViews.Concat(this, values instanceof FloatSeqLike ? (FloatSeqLike)values : ImmutableFloatSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView sorted() {
        return new FloatSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView reversed() {
        return new FloatSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView filter(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new FloatSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView filterNot(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new FloatSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView map(@NotNull FloatUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new FloatSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull FloatFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new FloatSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public FloatSeqView flatMap(@NotNull FloatFunction<? extends FloatTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new FloatSeqViews.FlatMapped(this, mapper);
    }

    @NotNull
    default public <T> SeqView<T> flatMapToObj(@NotNull FloatFunction<? extends Iterable<? extends T>> mapper) {
        Objects.requireNonNull(mapper);
        return new FloatSeqViews.FlatMapToObj(this, mapper);
    }
}

