/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.collection.AnySet;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.ImmutableFloatSet;
import kala.collection.primitive.FloatCollection;
import kala.collection.primitive.FloatSetLike;
import kala.collection.primitive.FloatSetView;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.internal.view.FloatSetViews;
import kala.function.FloatPredicate;
import org.jetbrains.annotations.NotNull;

public interface FloatSet
extends PrimitiveSet<Float>,
FloatCollection,
FloatSetLike {
    public static FloatCollectionFactory<?, FloatSet> factory() {
        return FloatCollectionFactory.narrow(ImmutableFloatSet.factory());
    }

    @NotNull
    public static FloatSet empty() {
        return ImmutableFloatSet.empty();
    }

    @NotNull
    public static FloatSet of() {
        return ImmutableFloatSet.of();
    }

    @NotNull
    public static FloatSet of(float value1) {
        return ImmutableFloatSet.of(value1);
    }

    @NotNull
    public static FloatSet of(float value1, float value2) {
        return ImmutableFloatSet.of(value1, value2);
    }

    @NotNull
    public static FloatSet of(float value1, float value2, float value3) {
        return ImmutableFloatSet.of(value1, value2, value3);
    }

    @NotNull
    public static FloatSet of(float value1, float value2, float value3, float value4) {
        return ImmutableFloatSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static FloatSet of(float value1, float value2, float value3, float value4, float value5) {
        return ImmutableFloatSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static FloatSet of(float ... values) {
        return ImmutableFloatSet.of(values);
    }

    @NotNull
    public static FloatSet from(float @NotNull [] values) {
        return ImmutableFloatSet.from(values);
    }

    @NotNull
    public static FloatSet from(@NotNull FloatTraversable values) {
        return ImmutableFloatSet.from(values);
    }

    @NotNull
    public static FloatSet from(@NotNull FloatIterator it) {
        return ImmutableFloatSet.from(it);
    }

    public static int hashCode(@NotNull FloatSet set) {
        int h = 1045751549;
        FloatIterator it = set.iterator();
        while (it.hasNext()) {
            h += Float.hashCode(it.nextFloat());
        }
        return h;
    }

    public static boolean equals(@NotNull FloatSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof FloatSet) {
            return set1.containsAll((FloatSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Float && set1.contains(((Float)v).floatValue())) continue;
            return false;
        }
        return true;
    }

    default public boolean contains(float value) {
        return this.iterator().contains(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "FloatSet";
    }

    @NotNull
    default public FloatCollectionFactory<?, ? extends FloatSet> iterableFactory() {
        return FloatSet.factory();
    }

    @Override
    @NotNull
    default public FloatSetView view() {
        return new FloatSetViews.Of<FloatSet>(this);
    }

    @Override
    @NotNull
    default public ImmutableFloatSet filter(@NotNull FloatPredicate predicate) {
        return ImmutableFloatSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableFloatSet filterNot(@NotNull FloatPredicate predicate) {
        return ImmutableFloatSet.from(this.view().filterNot(predicate));
    }
}

