/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import kala.Conditions;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.primitive.DoubleSeqLike;
import kala.control.primitive.DoubleOption;
import org.jetbrains.annotations.NotNull;

public interface IndexedDoubleSeqLike
extends DoubleSeqLike,
RandomAccess {
    @NotNull
    default public DoubleIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public DoubleIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return DoubleIterator.empty();
        }
        final class Itr
        extends AbstractDoubleIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public double nextDouble() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedDoubleSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public double get(int var1);

    @Override
    @NotNull
    default public DoubleIterator reverseIterator() {
        if (this.isEmpty()) {
            return DoubleIterator.empty();
        }
        return new AbstractDoubleIterator(){
            private int idx;
            {
                this.idx = IndexedDoubleSeqLike.this.size() - 1;
            }

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public double nextDouble() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedDoubleSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(double value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, double value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVal = this.get(mid);
            int cmp = Double.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public DoubleOption findFirst(@NotNull DoublePredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double e = this.get(i);
            if (!predicate.test(e)) continue;
            return DoubleOption.some((double)e);
        }
        return DoubleOption.none();
    }

    @Override
    @NotNull
    default public DoubleOption findLast(@NotNull DoublePredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            double e = this.get(i);
            if (!predicate.test(e)) continue;
            return DoubleOption.some((double)e);
        }
        return DoubleOption.none();
    }

    @Override
    default public double first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public double last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull DoubleConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

