/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import kala.collection.AnySeq;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.primitive.IntCollection;
import kala.collection.primitive.IntSeqLike;
import kala.collection.primitive.IntSeqView;
import kala.collection.primitive.PrimitiveSeq;
import kala.collection.primitive.internal.view.IntSeqViews;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface IntSeq
extends PrimitiveSeq<Integer>,
IntCollection,
IntSeqLike {
    @NotNull
    public static <E> IntCollectionFactory<?, IntSeq> factory() {
        return IntCollectionFactory.narrow(ImmutableIntSeq.factory());
    }

    @NotNull
    public static IntSeq empty() {
        return ImmutableIntSeq.empty();
    }

    @NotNull
    public static IntSeq of() {
        return ImmutableIntSeq.of();
    }

    @NotNull
    public static IntSeq of(int value1) {
        return ImmutableIntSeq.of(value1);
    }

    @NotNull
    public static IntSeq of(int value1, int value2) {
        return ImmutableIntSeq.of(value1, value2);
    }

    @NotNull
    public static IntSeq of(int value1, int value2, int value3) {
        return ImmutableIntSeq.of(value1, value2, value3);
    }

    @NotNull
    public static IntSeq of(int value1, int value2, int value3, int value4) {
        return ImmutableIntSeq.of(value1, value2, value3, value4);
    }

    @NotNull
    public static IntSeq of(int value1, int value2, int value3, int value4, int value5) {
        return ImmutableIntSeq.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static IntSeq of(int ... values) {
        return ImmutableIntSeq.of(values);
    }

    @NotNull
    public static IntSeq from(int @NotNull [] values) {
        return ImmutableIntSeq.from(values);
    }

    @NotNull
    public static IntSeq from(@NotNull IntTraversable values) {
        return ImmutableIntSeq.from(values);
    }

    @NotNull
    public static IntSeq from(@NotNull IntIterator it) {
        return ImmutableIntSeq.from(it);
    }

    @NotNull
    public static IntSeq fill(int n, int value) {
        return ImmutableIntSeq.fill(n, value);
    }

    @NotNull
    public static IntSeq fill(int n, @NotNull IntSupplier supplier) {
        return ImmutableIntSeq.fill(n, supplier);
    }

    public static int hashCode(@NotNull IntSeq seq) {
        return seq.iterator().hash() + -1140647423;
    }

    public static boolean equals(@NotNull IntSeq seq1, @NotNull AnySeq<?> seq2) {
        if (seq1 == seq2) {
            return true;
        }
        if (!seq1.canEqual(seq2) || !seq2.canEqual((Object)seq1)) {
            return false;
        }
        if (seq2 instanceof IntSeq) {
            return seq1.sameElements((IntSeq)seq2);
        }
        return seq1.sameElements((Iterable)seq2.asGeneric());
    }

    @Override
    @NotNull
    default public String className() {
        return "IntSeq";
    }

    @Override
    @NotNull
    default public IntSeqView view() {
        return this.isEmpty() ? IntSeqView.empty() : new IntSeqViews.Of<IntSeq>(this);
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends IntSeq> iterableFactory() {
        return IntSeq.factory();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq slice(int beginIndex, int endIndex) {
        return this.view().slice(beginIndex, endIndex).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq drop(int n) {
        return this.view().drop(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq dropLast(int n) {
        return this.view().dropLast(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq dropWhile(@NotNull IntPredicate predicate) {
        return this.view().dropWhile(predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq take(int n) {
        return this.view().take(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq takeLast(int n) {
        return this.view().takeLast(n).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq takeWhile(@NotNull IntPredicate predicate) {
        return this.view().takeWhile(predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq updated(int index, int newValue) {
        return this.view().updated(index, newValue).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq concat(@NotNull IntSeqLike other) {
        return this.view().concat(other).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq prepended(int value) {
        return this.view().prepended(value).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq prependedAll(int @NotNull [] values) {
        return this.view().prependedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq prependedAll(@NotNull IntTraversable values) {
        return this.view().prependedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq appended(int value) {
        return this.view().appended(value).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq appendedAll(@NotNull IntTraversable values) {
        return this.view().appendedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq appendedAll(int @NotNull [] values) {
        return this.view().appendedAll(values).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq sorted() {
        return this.view().sorted().toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq reversed() {
        return this.view().reversed().toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq filter(@NotNull IntPredicate predicate) {
        return this.view().filter(predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq filterNot(@NotNull IntPredicate predicate) {
        return this.view().filterNot(predicate).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq map(@NotNull IntUnaryOperator mapper) {
        return this.view().map(mapper).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <U> ImmutableSeq<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
        return this.view().mapToObj(mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntSeq flatMap(@NotNull IntFunction<? extends IntTraversable> mapper) {
        return this.view().flatMap((IntFunction)mapper).toImmutableSeq();
    }

    @Contract(pure=true)
    @NotNull
    default public <T> ImmutableSeq<T> flatMapToObj(@NotNull IntFunction<? extends Iterable<? extends T>> mapper) {
        return this.view().flatMapToObj(mapper).toImmutableSeq();
    }
}

