/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.primitive.IntCollectionLike;
import kala.collection.primitive.IntSeqIterator;
import kala.collection.primitive.IntSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.IntSeqIterators;
import kala.control.primitive.IntOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface IntSeqLike
extends PrimitiveSeqLike<Integer>,
IntCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "IntSeqLike";
    }

    @Override
    @NotNull
    public IntSeqView view();

    @NotNull
    default public IntIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return IntIterator.empty();
            }
        }
        IntIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextInt();
        }
        return it;
    }

    @NotNull
    default public IntSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public IntSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new IntSeqIterators.DefaultIntSeqIterator<IntSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public int elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public int get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextInt();
    }

    @Contract(pure=true)
    @Nullable
    default public Integer getOrNull(int index) {
        return this.isDefinedAt(index) ? Integer.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public IntOption getOption(int index) {
        return this.isDefinedAt(index) ? IntOption.some((int)this.get(index)) : IntOption.none();
    }

    @NotNull
    default public IntIterator reverseIterator() {
        IntIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableIntArrayList builder = new MutableIntArrayList();
        while (it.hasNext()) {
            builder.append(it.nextInt());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public IntOption find(@NotNull IntPredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public IntOption findFirst(@NotNull IntPredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public IntOption findLast(@NotNull IntPredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public int first() {
        return this.iterator().nextInt();
    }

    @Nullable
    default public Integer firstOrNull() {
        return this.isNotEmpty() ? Integer.valueOf(this.first()) : null;
    }

    @NotNull
    default public IntOption firstOption() {
        return this.isNotEmpty() ? IntOption.some((int)this.first()) : IntOption.none();
    }

    default public int last() {
        return this.reverseIterator().nextInt();
    }

    @Nullable
    default public Integer lastOrNull() {
        return this.isNotEmpty() ? Integer.valueOf(this.last()) : null;
    }

    @NotNull
    default public IntOption lastOption() {
        return this.isNotEmpty() ? IntOption.some((int)this.last()) : IntOption.none();
    }

    default public int first(@NotNull IntPredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Integer firstOrNull(@NotNull IntPredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public IntOption firstOption(@NotNull IntPredicate predicate) {
        return this.findFirst(predicate);
    }

    default public int last(@NotNull IntPredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Integer lastOrNull(@NotNull IntPredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public IntOption lastOption(@NotNull IntPredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(int value) {
        int idx = 0;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            if (value == it.nextInt()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(int value, int from) {
        int idx = 0;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && value == it.nextInt()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull IntPredicate predicate) {
        int idx = 0;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextInt())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull IntPredicate predicate, int from) {
        int idx = 0;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextInt())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(int value) {
        int idx = this.size() - 1;
        IntIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (value == it.nextInt()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(int value, int end) {
        int idx = this.size() - 1;
        IntIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && value == it.nextInt()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull IntPredicate predicate) {
        int idx = this.size() - 1;
        IntIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextInt())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull IntPredicate predicate, int end) {
        int idx = this.size() - 1;
        IntIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextInt())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public IntSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike dropWhile(@NotNull IntPredicate var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike take(int var1);

    @NotNull
    public IntSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike takeWhile(@NotNull IntPredicate var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike updated(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike concat(@NotNull IntSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike prepended(int var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike prependedAll(int @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike prependedAll(@NotNull IntTraversable var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike appended(int var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike appendedAll(@NotNull IntTraversable var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike appendedAll(int @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public IntSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public IntSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public IntSeqLike filter(@NotNull IntPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public IntSeqLike filterNot(@NotNull IntPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public IntSeqLike map(@NotNull IntUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull IntFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public IntSeqLike flatMap(@NotNull IntFunction<? extends IntTraversable> var1);

    @NotNull
    public <T> SeqLike<T> flatMapToObj(@NotNull IntFunction<? extends Iterable<? extends T>> var1);
}

