/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.immutable.primitive.ImmutableShortSeq;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.ShortArraySeq;
import kala.collection.primitive.ShortCollectionView;
import kala.collection.primitive.ShortSeqLike;
import kala.collection.primitive.internal.view.ShortSeqViews;
import kala.function.ShortFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ShortSeqView
extends ShortSeqLike,
ShortCollectionView,
PrimitiveSeqView<Short> {
    @NotNull
    public static ShortSeqView empty() {
        return ShortSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "ShortSeqView";
    }

    @Override
    @NotNull
    default public ShortSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return ShortSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new ShortSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ShortSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return ShortSeqView.empty();
        }
        return new ShortSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ShortSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return ShortSeqView.empty();
        }
        return new ShortSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView dropWhile(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ShortSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ShortSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ShortSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new ShortSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public ShortSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ShortSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return ShortSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new ShortSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView takeWhile(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ShortSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView updated(int index, short newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new ShortSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView concat(@NotNull ShortSeqLike other) {
        Objects.requireNonNull(other);
        return new ShortSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView prepended(short value) {
        return new ShortSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView prependedAll(short @NotNull [] values) {
        Objects.requireNonNull(values);
        return new ShortSeqViews.Concat(ShortArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView prependedAll(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        return new ShortSeqViews.Concat(values instanceof ShortSeqLike ? (ShortSeqLike)values : ImmutableShortSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView appended(short value) {
        return new ShortSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView appendedAll(short @NotNull [] values) {
        Objects.requireNonNull(values);
        return new ShortSeqViews.Concat(this, ShortArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView appendedAll(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        return new ShortSeqViews.Concat(this, values instanceof ShortSeqLike ? (ShortSeqLike)values : ImmutableShortSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView sorted() {
        return new ShortSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView reversed() {
        return new ShortSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView filter(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ShortSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView filterNot(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new ShortSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView map(@NotNull ShortUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new ShortSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull ShortFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new ShortSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ShortSeqView flatMap(@NotNull ShortFunction<? extends ShortTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new ShortSeqViews.FlatMapped(this, mapper);
    }

    @NotNull
    default public <T> SeqView<T> flatMapToObj(@NotNull ShortFunction<? extends Iterable<? extends T>> mapper) {
        Objects.requireNonNull(mapper);
        return new ShortSeqViews.FlatMapToObj(this, mapper);
    }
}

