/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.collection.AnySet;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.ImmutableShortSet;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.ShortCollection;
import kala.collection.primitive.ShortSetLike;
import kala.collection.primitive.ShortSetView;
import kala.collection.primitive.internal.view.ShortSetViews;
import kala.function.ShortPredicate;
import org.jetbrains.annotations.NotNull;

public interface ShortSet
extends PrimitiveSet<Short>,
ShortCollection,
ShortSetLike {
    public static ShortCollectionFactory<?, ShortSet> factory() {
        return ShortCollectionFactory.narrow(ImmutableShortSet.factory());
    }

    @NotNull
    public static ShortSet empty() {
        return ImmutableShortSet.empty();
    }

    @NotNull
    public static ShortSet of() {
        return ImmutableShortSet.of();
    }

    @NotNull
    public static ShortSet of(short value1) {
        return ImmutableShortSet.of(value1);
    }

    @NotNull
    public static ShortSet of(short value1, short value2) {
        return ImmutableShortSet.of(value1, value2);
    }

    @NotNull
    public static ShortSet of(short value1, short value2, short value3) {
        return ImmutableShortSet.of(value1, value2, value3);
    }

    @NotNull
    public static ShortSet of(short value1, short value2, short value3, short value4) {
        return ImmutableShortSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ShortSet of(short value1, short value2, short value3, short value4, short value5) {
        return ImmutableShortSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ShortSet of(short ... values) {
        return ImmutableShortSet.of(values);
    }

    @NotNull
    public static ShortSet from(short @NotNull [] values) {
        return ImmutableShortSet.from(values);
    }

    @NotNull
    public static ShortSet from(@NotNull ShortTraversable values) {
        return ImmutableShortSet.from(values);
    }

    @NotNull
    public static ShortSet from(@NotNull ShortIterator it) {
        return ImmutableShortSet.from(it);
    }

    public static int hashCode(@NotNull ShortSet set) {
        int h = 1045751549;
        ShortIterator it = set.iterator();
        while (it.hasNext()) {
            h += Short.hashCode(it.nextShort());
        }
        return h;
    }

    public static boolean equals(@NotNull ShortSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof ShortSet) {
            return set1.containsAll((ShortSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Short && set1.contains((Short)v)) continue;
            return false;
        }
        return true;
    }

    default public boolean contains(short value) {
        return this.iterator().contains(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "ShortSet";
    }

    @NotNull
    default public ShortCollectionFactory<?, ? extends ShortSet> iterableFactory() {
        return ShortSet.factory();
    }

    @Override
    @NotNull
    default public ShortSetView view() {
        return new ShortSetViews.Of<ShortSet>(this);
    }

    @Override
    @NotNull
    default public ImmutableShortSet filter(@NotNull ShortPredicate predicate) {
        return ImmutableShortSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableShortSet filterNot(@NotNull ShortPredicate predicate) {
        return ImmutableShortSet.from(this.view().filterNot(predicate));
    }
}

