/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.mutable.primitive.MutableIntList;
import kala.collection.mutable.primitive.MutableIntListIterator;
import kala.collection.mutable.primitive.MutableIntSeq;
import kala.collection.mutable.primitive.MutableIntSeqIterator;
import kala.collection.primitive.AbstractIntSeqIterator;
import kala.collection.primitive.IntSeqIterator;
import kala.collection.primitive.IntSeqLike;
import org.jetbrains.annotations.NotNull;

public final class IntSeqIterators {
    public static final IntSeqIterator EMPTY = new EmptyIntSeqIterator();
    public static final MutableIntSeqIterator EMPTY_MUTABLE = new EmptyMutableIntSeqIterator();

    private IntSeqIterators() {
    }

    private static class EmptyIntSeqIterator
    extends AbstractIntIterator
    implements IntSeqIterator {
        private EmptyIntSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousInt() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableIntSeqIterator
    extends EmptyIntSeqIterator
    implements MutableIntSeqIterator {
        private EmptyMutableIntSeqIterator() {
        }

        @Override
        public void set(int e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenIntSeqIterator
    implements IntSeqIterator {
        @NotNull
        private final IntSeqIterator source;

        public FrozenIntSeqIterator(@NotNull IntSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public int nextInt() {
            return this.source.nextInt();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public int previousInt() {
            return this.source.previousInt();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenIntSeqIterator[" + this.source + ']';
        }
    }

    public static class DefaultMutableIntListIterator<S extends MutableIntList>
    extends DefaultMutableIntSeqIterator<S>
    implements MutableIntListIterator {
        public DefaultMutableIntListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(int e) {
            try {
                int i = this.cursor;
                ((MutableIntList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableIntList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableIntSeqIterator<S extends MutableIntSeq>
    extends DefaultIntSeqIterator<S>
    implements MutableIntSeqIterator {
        public DefaultMutableIntSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(int e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableIntSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultIntSeqIterator<S extends IntSeqLike>
    extends AbstractIntSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultIntSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public int nextInt() {
            try {
                int i = this.cursor;
                int next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousInt() {
            try {
                int i = this.cursor - 1;
                int previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

