/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.primitive.AbstractBooleanCollectionView;
import kala.collection.primitive.BooleanCollectionLike;
import kala.collection.primitive.BooleanCollectionView;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanConsumer;
import kala.function.BooleanFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class BooleanCollectionViews {
    public static final BooleanCollectionView EMPTY = new Empty();

    private BooleanCollectionViews() {
    }

    public static class Empty
    extends AbstractBooleanCollectionView {
        @NotNull
        public final BooleanIterator iterator() {
            return BooleanIterator.empty();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public BooleanCollectionView filter(@NotNull BooleanPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public BooleanCollectionView filterNot(@NotNull BooleanPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public BooleanCollectionView map(@NotNull BooleanUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull BooleanFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public BooleanCollectionView flatMap(@NotNull BooleanFunction<? extends BooleanTraversable> mapper) {
            return this;
        }

        public final boolean @NotNull [] toArray() {
            return BooleanArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final BooleanCollectionView source;
        @NotNull
        private final BooleanFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull BooleanCollectionView source, @NotNull BooleanFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> ((Iterable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractBooleanCollectionView {
        @NotNull
        private final BooleanCollectionView source;
        @NotNull
        private final BooleanFunction<? extends BooleanTraversable> mapper;

        public FlatMapped(@NotNull BooleanCollectionView source, @NotNull BooleanFunction<? extends BooleanTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public BooleanIterator iterator() {
            return BooleanIterator.concat(this.source.mapToObj(it -> ((BooleanTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractBooleanCollectionView {
        @NotNull
        private final BooleanCollectionView source;
        @NotNull
        private final BooleanPredicate predicate;

        public FilterNot(@NotNull BooleanCollectionView source, @NotNull BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public BooleanIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractBooleanCollectionView {
        @NotNull
        private final BooleanCollectionView source;
        @NotNull
        private final BooleanPredicate predicate;

        public Filter(@NotNull BooleanCollectionView source, @NotNull BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public BooleanIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final BooleanCollectionView source;
        @NotNull
        private final BooleanFunction<? extends T> mapper;

        public MapToObj(@NotNull BooleanCollectionView source, @NotNull BooleanFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractBooleanCollectionView {
        @NotNull
        private final BooleanCollectionView source;
        @NotNull
        private final BooleanUnaryOperator mapper;

        public Mapped(@NotNull BooleanCollectionView source, @NotNull BooleanUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public BooleanIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends BooleanCollectionLike>
    extends AbstractBooleanCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public BooleanOption find(@NotNull BooleanPredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(boolean value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(boolean @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull BooleanTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull BooleanPredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull BooleanPredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull BooleanPredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull BooleanPredicate predicate) {
            return this.source.count(predicate);
        }

        public final boolean max() {
            return this.source.max();
        }

        public final boolean min() {
            return this.source.min();
        }

        public final boolean @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull BooleanConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractBooleanCollectionView {
        protected final boolean value;

        public Single(boolean value) {
            this.value = value;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return BooleanIterator.of((boolean)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull BooleanConsumer action) {
            action.accept(this.value);
        }
    }
}

