/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.mutable.primitive.MutableByteArrayList;
import kala.collection.primitive.AbstractByteSeqView;
import kala.collection.primitive.ByteSeq;
import kala.collection.primitive.ByteSeqLike;
import kala.collection.primitive.ByteSeqView;
import kala.collection.primitive.IndexedByteSeqLike;
import kala.collection.primitive.internal.view.ByteCollectionViews;
import kala.function.ByteFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ByteSeqViews {
    public static final ByteSeqView EMPTY = new Empty();

    public static class Empty
    extends ByteCollectionViews.Empty
    implements ByteSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public ByteSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public ByteIterator reverseIterator() {
            return ByteIterator.empty();
        }

        @Override
        public byte get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public ByteSeqView concat(@NotNull ByteSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public ByteSeqView filter(@NotNull BytePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ByteSeqView filterNot(@NotNull BytePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ByteSeqView map(@NotNull ByteUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull ByteFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public ByteSeqView flatMap(@NotNull ByteFunction<? extends ByteTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public ByteSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractByteSeqView {
        private final ByteSeqView source;
        private byte[] sorted;

        public Sorted(@NotNull ByteSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                byte[] arr = this.source.toArray();
                ByteArrays.sort((byte[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final ByteIterator iterator() {
            this.initSorted();
            return ByteArrays.iterator((byte[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final byte get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final ByteSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final ByteSeqView source;
        @NotNull
        private final ByteFunction<? extends E> mapper;

        public MapToObj(@NotNull ByteSeqView source, @NotNull ByteFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return (E)this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        @NotNull
        private final ByteUnaryOperator mapper;

        public Mapped(@NotNull ByteSeqView source, @NotNull ByteUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final byte get(int index) {
            return this.mapper.applyAsByte(this.source.get(index));
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractSeqView<T> {
        @NotNull
        private final ByteSeqLike source;
        @NotNull
        private final ByteFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull ByteSeqLike source, @NotNull ByteFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> ((Iterable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqLike source;
        @NotNull
        private final ByteFunction<? extends ByteTraversable> mapper;

        public FlatMapped(@NotNull ByteSeqLike source, @NotNull ByteFunction<? extends ByteTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final ByteIterator iterator() {
            return ByteIterator.concat(this.source.mapToObj(it -> ((ByteTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        @NotNull
        private final BytePredicate predicate;

        public FilterNot(@NotNull ByteSeqView source, @NotNull BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        @NotNull
        private final BytePredicate predicate;

        public Filter(@NotNull ByteSeqView source, @NotNull BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public ByteIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;

        public Reversed(@NotNull ByteSeqView source) {
            this.source = source;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final byte get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final ByteSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final ByteIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;
        protected final byte value;

        public Appended(@NotNull ByteSeqView source, byte value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        private final byte value;

        public Prepended(@NotNull ByteSeqView source, byte value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final byte get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqLike seq1;
        @NotNull
        protected final ByteSeqLike seq2;

        public Concat(@NotNull ByteSeqLike seq1, @NotNull ByteSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final ByteIterator iterator() {
            return ByteIterator.concat((ByteIterator)this.seq1.iterator(), (ByteIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        @NotNull
        private final BytePredicate predicate;

        public TakeWhile(@NotNull ByteSeqView source, @NotNull BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull ByteSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final byte get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final ByteIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return ByteIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractByteIterator(){
                ByteIterator it;
                int len;
                int pos;
                MutableByteArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableByteArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        byte next = this.it.nextByte();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final byte nextByte() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    byte v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull ByteSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public ByteSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        @NotNull
        private final BytePredicate predicate;

        public DropWhile(@NotNull ByteSeqView source, @NotNull BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull ByteSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final ByteIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return ByteIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final byte get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            ByteSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;
        protected final int n;

        public Drop(@NotNull ByteSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.iterator().drop(this.n);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public ByteSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractByteSeqView {
        @NotNull
        private final ByteSeqView source;
        private final int index;
        private final byte newValue;

        public Updated(@NotNull ByteSeqView source, int index, byte newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final ByteIterator iterator() {
            return new AbstractByteIterator(){
                private final ByteIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final byte nextByte() {
                    byte value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final byte get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractByteSeqView {
        @NotNull
        protected final ByteSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull ByteSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public ByteIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractByteIterator {
            private int idx;
            private final ByteIterator it;

            Itr() {
                ByteIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final byte nextByte() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    byte next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends ByteSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((ByteSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((ByteSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((ByteSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements ByteSeqView,
    IndexedByteSeqLike {
        protected final byte[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(byte[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public ByteIterator iterator() {
            return ByteArrays.iterator((byte[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final byte get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public ByteSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public ByteSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public ByteSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public ByteSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public ByteSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends ByteSeqLike>
    extends ByteCollectionViews.Of<C>
    implements ByteSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((ByteSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public byte get(int index) {
            return ((ByteSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((ByteSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(byte value) {
            return ((ByteSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(byte value, int from) {
            return ((ByteSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull BytePredicate predicate) {
            return ((ByteSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull BytePredicate predicate, int from) {
            return ((ByteSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(byte value) {
            return ((ByteSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(byte value, int end) {
            return ((ByteSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull BytePredicate predicate) {
            return ((ByteSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull BytePredicate predicate, int end) {
            return ((ByteSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public ByteIterator reverseIterator() {
            return ((ByteSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends ByteCollectionViews.Single
    implements ByteSeqView {
        public Single(byte value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public ByteSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final ByteIterator reverseIterator() {
            return ByteIterator.of((byte)this.value);
        }

        @Override
        public byte get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public ByteSeqView updated(int index, byte newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

