/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.mutable.primitive.MutableCharArrayList;
import kala.collection.primitive.AbstractCharSeqView;
import kala.collection.primitive.CharSeq;
import kala.collection.primitive.CharSeqLike;
import kala.collection.primitive.CharSeqView;
import kala.collection.primitive.IndexedCharSeqLike;
import kala.collection.primitive.internal.view.CharCollectionViews;
import kala.function.CharFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class CharSeqViews {
    public static final CharSeqView EMPTY = new Empty();

    public static class Empty
    extends CharCollectionViews.Empty
    implements CharSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public CharSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public CharIterator reverseIterator() {
            return CharIterator.empty();
        }

        @Override
        public char get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public CharSeqView concat(@NotNull CharSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public CharSeqView filter(@NotNull CharPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public CharSeqView filterNot(@NotNull CharPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public CharSeqView map(@NotNull CharUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull CharFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public CharSeqView flatMap(@NotNull CharFunction<? extends CharTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public CharSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractCharSeqView {
        private final CharSeqView source;
        private char[] sorted;

        public Sorted(@NotNull CharSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                char[] arr = this.source.toArray();
                CharArrays.sort((char[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final CharIterator iterator() {
            this.initSorted();
            return CharArrays.iterator((char[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final char get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final CharSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final CharSeqView source;
        @NotNull
        private final CharFunction<? extends E> mapper;

        public MapToObj(@NotNull CharSeqView source, @NotNull CharFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return (E)this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        @NotNull
        private final CharUnaryOperator mapper;

        public Mapped(@NotNull CharSeqView source, @NotNull CharUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final char get(int index) {
            return this.mapper.applyAsChar(this.source.get(index));
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractSeqView<T> {
        @NotNull
        private final CharSeqLike source;
        @NotNull
        private final CharFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull CharSeqLike source, @NotNull CharFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> ((Iterable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqLike source;
        @NotNull
        private final CharFunction<? extends CharTraversable> mapper;

        public FlatMapped(@NotNull CharSeqLike source, @NotNull CharFunction<? extends CharTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final CharIterator iterator() {
            return CharIterator.concat(this.source.mapToObj(it -> ((CharTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        @NotNull
        private final CharPredicate predicate;

        public FilterNot(@NotNull CharSeqView source, @NotNull CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        @NotNull
        private final CharPredicate predicate;

        public Filter(@NotNull CharSeqView source, @NotNull CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public CharIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;

        public Reversed(@NotNull CharSeqView source) {
            this.source = source;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final char get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final CharSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final CharIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;
        protected final char value;

        public Appended(@NotNull CharSeqView source, char value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        private final char value;

        public Prepended(@NotNull CharSeqView source, char value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final char get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqLike seq1;
        @NotNull
        protected final CharSeqLike seq2;

        public Concat(@NotNull CharSeqLike seq1, @NotNull CharSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final CharIterator iterator() {
            return CharIterator.concat((CharIterator)this.seq1.iterator(), (CharIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        @NotNull
        private final CharPredicate predicate;

        public TakeWhile(@NotNull CharSeqView source, @NotNull CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull CharSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final char get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final CharIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return CharIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractCharIterator(){
                CharIterator it;
                int len;
                int pos;
                MutableCharArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableCharArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        char next = this.it.nextChar();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final char nextChar() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    char v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull CharSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public CharSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        @NotNull
        private final CharPredicate predicate;

        public DropWhile(@NotNull CharSeqView source, @NotNull CharPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull CharSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final CharIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return CharIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final char get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            CharSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;
        protected final int n;

        public Drop(@NotNull CharSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final CharIterator iterator() {
            return this.iterator().drop(this.n);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public CharSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractCharSeqView {
        @NotNull
        private final CharSeqView source;
        private final int index;
        private final char newValue;

        public Updated(@NotNull CharSeqView source, int index, char newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final CharIterator iterator() {
            return new AbstractCharIterator(){
                private final CharIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final char nextChar() {
                    char value = this.it.next().charValue();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final char get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractCharSeqView {
        @NotNull
        protected final CharSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull CharSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public CharIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractCharIterator {
            private int idx;
            private final CharIterator it;

            Itr() {
                CharIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final char nextChar() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    char next = this.it.next().charValue();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends CharSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((CharSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((CharSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((CharSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements CharSeqView,
    IndexedCharSeqLike {
        protected final char[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(char[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public CharIterator iterator() {
            return CharArrays.iterator((char[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final char get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public CharSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public CharSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public CharSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public CharSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public CharSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends CharSeqLike>
    extends CharCollectionViews.Of<C>
    implements CharSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((CharSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public char get(int index) {
            return ((CharSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((CharSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(char value) {
            return ((CharSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(char value, int from) {
            return ((CharSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull CharPredicate predicate) {
            return ((CharSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull CharPredicate predicate, int from) {
            return ((CharSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(char value) {
            return ((CharSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(char value, int end) {
            return ((CharSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull CharPredicate predicate) {
            return ((CharSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull CharPredicate predicate, int end) {
            return ((CharSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public CharIterator reverseIterator() {
            return ((CharSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends CharCollectionViews.Single
    implements CharSeqView {
        public Single(char value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public CharSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final CharIterator reverseIterator() {
            return CharIterator.of((char)this.value);
        }

        @Override
        public char get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public CharSeqView updated(int index, char newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

