/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.primitive.AbstractDoubleCollectionView;
import kala.collection.primitive.DoubleCollectionLike;
import kala.collection.primitive.DoubleCollectionView;
import kala.control.primitive.DoubleOption;
import org.jetbrains.annotations.NotNull;

public final class DoubleCollectionViews {
    public static final DoubleCollectionView EMPTY = new Empty();

    private DoubleCollectionViews() {
    }

    public static class Empty
    extends AbstractDoubleCollectionView {
        @NotNull
        public final DoubleIterator iterator() {
            return DoubleIterator.empty();
        }

        @NotNull
        public DoubleStream stream() {
            return DoubleStream.empty();
        }

        @NotNull
        public DoubleStream parallelStream() {
            return DoubleStream.empty().parallel();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public DoubleCollectionView filter(@NotNull DoublePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public DoubleCollectionView filterNot(@NotNull DoublePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public DoubleCollectionView map(@NotNull DoubleUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull DoubleFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public DoubleCollectionView flatMap(@NotNull DoubleFunction<? extends DoubleTraversable> mapper) {
            return this;
        }

        public final double @NotNull [] toArray() {
            return DoubleArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    static final class MappedSpliterator
    implements Spliterator.OfDouble {
        @NotNull
        private final Spliterator.OfDouble source;
        @NotNull
        private final DoubleUnaryOperator mapper;

        MappedSpliterator(@NotNull Spliterator.OfDouble source, @NotNull DoubleUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            Objects.requireNonNull(action);
            return this.source.tryAdvance((double t) -> action.accept(this.mapper.applyAsDouble(t)));
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            Spliterator.OfDouble ss = this.source.trySplit();
            return ss != null ? new MappedSpliterator(ss, this.mapper) : null;
        }

        @Override
        public long estimateSize() {
            return this.source.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.source.characteristics();
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final DoubleCollectionView source;
        @NotNull
        private final DoubleFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull DoubleCollectionView source, @NotNull DoubleFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractDoubleCollectionView {
        @NotNull
        private final DoubleCollectionView source;
        @NotNull
        private final DoubleFunction<? extends DoubleTraversable> mapper;

        public FlatMapped(@NotNull DoubleCollectionView source, @NotNull DoubleFunction<? extends DoubleTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public DoubleIterator iterator() {
            return DoubleIterator.concat(this.source.mapToObj((double it) -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractDoubleCollectionView {
        @NotNull
        private final DoubleCollectionView source;
        @NotNull
        private final DoublePredicate predicate;

        public FilterNot(@NotNull DoubleCollectionView source, @NotNull DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public DoubleIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.stream().filter(this.predicate.negate()).parallel();
        }
    }

    public static final class Filter
    extends AbstractDoubleCollectionView {
        @NotNull
        private final DoubleCollectionView source;
        @NotNull
        private final DoublePredicate predicate;

        public Filter(@NotNull DoubleCollectionView source, @NotNull DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public DoubleIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.stream().filter(this.predicate).parallel();
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final DoubleCollectionView source;
        @NotNull
        private final DoubleFunction<? extends T> mapper;

        public MapToObj(@NotNull DoubleCollectionView source, @NotNull DoubleFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractDoubleCollectionView {
        @NotNull
        private final DoubleCollectionView source;
        @NotNull
        private final DoubleUnaryOperator mapper;

        public Mapped(@NotNull DoubleCollectionView source, @NotNull DoubleUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public DoubleIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        @NotNull
        public Spliterator.OfDouble spliterator() {
            return new MappedSpliterator(this.source.spliterator(), this.mapper);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends DoubleCollectionLike>
    extends AbstractDoubleCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator();
        }

        @NotNull
        public final Spliterator.OfDouble spliterator() {
            return this.source.spliterator();
        }

        @NotNull
        public final DoubleStream stream() {
            return this.source.stream();
        }

        @NotNull
        public final DoubleStream parallelStream() {
            return this.source.parallelStream();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public DoubleOption find(@NotNull DoublePredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(double value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(double @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull DoubleTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull DoublePredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull DoublePredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull DoublePredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull DoublePredicate predicate) {
            return this.source.count(predicate);
        }

        public final double max() {
            return this.source.max();
        }

        public final double min() {
            return this.source.min();
        }

        public final double @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull DoubleConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractDoubleCollectionView {
        protected final double value;

        public Single(double value) {
            this.value = value;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return DoubleIterator.of((double)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull DoubleConsumer action) {
            action.accept(this.value);
        }
    }
}

