/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.mutable.primitive.MutableFloatArrayList;
import kala.collection.primitive.AbstractFloatSeqView;
import kala.collection.primitive.FloatSeq;
import kala.collection.primitive.FloatSeqLike;
import kala.collection.primitive.FloatSeqView;
import kala.collection.primitive.IndexedFloatSeqLike;
import kala.collection.primitive.internal.view.FloatCollectionViews;
import kala.function.FloatFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class FloatSeqViews {
    public static final FloatSeqView EMPTY = new Empty();

    public static class Empty
    extends FloatCollectionViews.Empty
    implements FloatSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public FloatSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public FloatIterator reverseIterator() {
            return FloatIterator.empty();
        }

        @Override
        public float get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public FloatSeqView concat(@NotNull FloatSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public FloatSeqView filter(@NotNull FloatPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public FloatSeqView filterNot(@NotNull FloatPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public FloatSeqView map(@NotNull FloatUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull FloatFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public FloatSeqView flatMap(@NotNull FloatFunction<? extends FloatTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public FloatSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractFloatSeqView {
        private final FloatSeqView source;
        private float[] sorted;

        public Sorted(@NotNull FloatSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                float[] arr = this.source.toArray();
                FloatArrays.sort((float[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final FloatIterator iterator() {
            this.initSorted();
            return FloatArrays.iterator((float[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final float get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final FloatSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final FloatSeqView source;
        @NotNull
        private final FloatFunction<? extends E> mapper;

        public MapToObj(@NotNull FloatSeqView source, @NotNull FloatFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return (E)this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        @NotNull
        private final FloatUnaryOperator mapper;

        public Mapped(@NotNull FloatSeqView source, @NotNull FloatUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final float get(int index) {
            return this.mapper.applyAsFloat(this.source.get(index));
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractSeqView<T> {
        @NotNull
        private final FloatSeqLike source;
        @NotNull
        private final FloatFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull FloatSeqLike source, @NotNull FloatFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> ((Iterable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqLike source;
        @NotNull
        private final FloatFunction<? extends FloatTraversable> mapper;

        public FlatMapped(@NotNull FloatSeqLike source, @NotNull FloatFunction<? extends FloatTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final FloatIterator iterator() {
            return FloatIterator.concat(this.source.mapToObj(it -> ((FloatTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        @NotNull
        private final FloatPredicate predicate;

        public FilterNot(@NotNull FloatSeqView source, @NotNull FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        @NotNull
        private final FloatPredicate predicate;

        public Filter(@NotNull FloatSeqView source, @NotNull FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public FloatIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;

        public Reversed(@NotNull FloatSeqView source) {
            this.source = source;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final float get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final FloatSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final FloatIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;
        protected final float value;

        public Appended(@NotNull FloatSeqView source, float value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        private final float value;

        public Prepended(@NotNull FloatSeqView source, float value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final float get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqLike seq1;
        @NotNull
        protected final FloatSeqLike seq2;

        public Concat(@NotNull FloatSeqLike seq1, @NotNull FloatSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final FloatIterator iterator() {
            return FloatIterator.concat((FloatIterator)this.seq1.iterator(), (FloatIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        @NotNull
        private final FloatPredicate predicate;

        public TakeWhile(@NotNull FloatSeqView source, @NotNull FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull FloatSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final float get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final FloatIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return FloatIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractFloatIterator(){
                FloatIterator it;
                int len;
                int pos;
                MutableFloatArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableFloatArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        float next = this.it.nextFloat();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final float nextFloat() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    float v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull FloatSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public FloatSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        @NotNull
        private final FloatPredicate predicate;

        public DropWhile(@NotNull FloatSeqView source, @NotNull FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull FloatSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final FloatIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return FloatIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final float get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            FloatSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;
        protected final int n;

        public Drop(@NotNull FloatSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.iterator().drop(this.n);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public FloatSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractFloatSeqView {
        @NotNull
        private final FloatSeqView source;
        private final int index;
        private final float newValue;

        public Updated(@NotNull FloatSeqView source, int index, float newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final FloatIterator iterator() {
            return new AbstractFloatIterator(){
                private final FloatIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final float nextFloat() {
                    float value = this.it.next().floatValue();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final float get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractFloatSeqView {
        @NotNull
        protected final FloatSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull FloatSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public FloatIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractFloatIterator {
            private int idx;
            private final FloatIterator it;

            Itr() {
                FloatIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final float nextFloat() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    float next = this.it.next().floatValue();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends FloatSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((FloatSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((FloatSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((FloatSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements FloatSeqView,
    IndexedFloatSeqLike {
        protected final float[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(float[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public FloatIterator iterator() {
            return FloatArrays.iterator((float[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final float get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public FloatSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public FloatSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public FloatSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public FloatSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public FloatSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends FloatSeqLike>
    extends FloatCollectionViews.Of<C>
    implements FloatSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((FloatSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public float get(int index) {
            return ((FloatSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((FloatSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(float value) {
            return ((FloatSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(float value, int from) {
            return ((FloatSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull FloatPredicate predicate) {
            return ((FloatSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull FloatPredicate predicate, int from) {
            return ((FloatSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(float value) {
            return ((FloatSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(float value, int end) {
            return ((FloatSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull FloatPredicate predicate) {
            return ((FloatSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull FloatPredicate predicate, int end) {
            return ((FloatSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public FloatIterator reverseIterator() {
            return ((FloatSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends FloatCollectionViews.Single
    implements FloatSeqView {
        public Single(float value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public FloatSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final FloatIterator reverseIterator() {
            return FloatIterator.of((float)this.value);
        }

        @Override
        public float get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public FloatSeqView updated(int index, float newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

