/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.primitive.AbstractShortCollectionView;
import kala.collection.primitive.ShortCollectionLike;
import kala.collection.primitive.ShortCollectionView;
import kala.control.primitive.ShortOption;
import kala.function.ShortConsumer;
import kala.function.ShortFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class ShortCollectionViews {
    public static final ShortCollectionView EMPTY = new Empty();

    private ShortCollectionViews() {
    }

    public static class Empty
    extends AbstractShortCollectionView {
        @NotNull
        public final ShortIterator iterator() {
            return ShortIterator.empty();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public ShortCollectionView filter(@NotNull ShortPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ShortCollectionView filterNot(@NotNull ShortPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ShortCollectionView map(@NotNull ShortUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull ShortFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public ShortCollectionView flatMap(@NotNull ShortFunction<? extends ShortTraversable> mapper) {
            return this;
        }

        public final short @NotNull [] toArray() {
            return ShortArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    public static final class FlatMapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final ShortCollectionView source;
        @NotNull
        private final ShortFunction<? extends Iterable<? extends T>> mapper;

        public FlatMapToObj(@NotNull ShortCollectionView source, @NotNull ShortFunction<? extends Iterable<? extends T>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return Iterators.concat(this.source.mapToObj(it -> ((Iterable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FlatMapped
    extends AbstractShortCollectionView {
        @NotNull
        private final ShortCollectionView source;
        @NotNull
        private final ShortFunction<? extends ShortTraversable> mapper;

        public FlatMapped(@NotNull ShortCollectionView source, @NotNull ShortFunction<? extends ShortTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public ShortIterator iterator() {
            return ShortIterator.concat(this.source.mapToObj(it -> ((ShortTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractShortCollectionView {
        @NotNull
        private final ShortCollectionView source;
        @NotNull
        private final ShortPredicate predicate;

        public FilterNot(@NotNull ShortCollectionView source, @NotNull ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public ShortIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractShortCollectionView {
        @NotNull
        private final ShortCollectionView source;
        @NotNull
        private final ShortPredicate predicate;

        public Filter(@NotNull ShortCollectionView source, @NotNull ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public ShortIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final ShortCollectionView source;
        @NotNull
        private final ShortFunction<? extends T> mapper;

        public MapToObj(@NotNull ShortCollectionView source, @NotNull ShortFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractShortCollectionView {
        @NotNull
        private final ShortCollectionView source;
        @NotNull
        private final ShortUnaryOperator mapper;

        public Mapped(@NotNull ShortCollectionView source, @NotNull ShortUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public ShortIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends ShortCollectionLike>
    extends AbstractShortCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public ShortOption find(@NotNull ShortPredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(short value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(short @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull ShortTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull ShortPredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull ShortPredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull ShortPredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull ShortPredicate predicate) {
            return this.source.count(predicate);
        }

        public final short max() {
            return this.source.max();
        }

        public final short min() {
            return this.source.min();
        }

        public final short @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull ShortConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractShortCollectionView {
        protected final short value;

        public Single(short value) {
            this.value = value;
        }

        @NotNull
        public final ShortIterator iterator() {
            return ShortIterator.of((short)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull ShortConsumer action) {
            action.accept(this.value);
        }
    }
}

