/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.immutable.primitive.ImmutableByteSeq;
import kala.collection.primitive.AbstractByteSeq;
import kala.collection.primitive.ByteSeqLike;
import kala.function.BytePredicate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableByteSeq
extends AbstractByteSeq
implements ImmutableByteSeq {
    static <T, Builder> T updated(@NotNull ImmutableByteSeq seq, int index, byte newValue, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        ByteIterator it = seq.iterator();
        while (it.hasNext()) {
            byte e = it.nextByte();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableByteSeq, Builder> T slice(@NotNull ImmutableByteSeq seq, int beginIndex, int endIndex, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableByteSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            ByteIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextByte());
            }
        }
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T drop(@NotNull ImmutableByteSeq seq, int n, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        ByteIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            byte e = it.nextByte();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T dropLast(@NotNull ImmutableByteSeq seq, int n, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableByteSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            ByteIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextByte());
            }
        }
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T dropWhile(@NotNull ImmutableByteSeq seq, @NotNull BytePredicate predicate, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T take(@NotNull ImmutableByteSeq seq, int n, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableByteSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        ByteIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextByte());
        }
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T takeLast(@NotNull ImmutableByteSeq seq, int n, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableByteSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            ByteIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextByte();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextByte());
            }
        }
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T takeWhile(@NotNull ImmutableByteSeq seq, @NotNull BytePredicate predicate, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T extends ImmutableByteSeq, Builder> T concat(@NotNull ImmutableByteSeq seq, @NotNull ByteSeqLike other, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (ByteTraversable)other);
        return (T)((ImmutableByteSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableByteSeq seq, byte element, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableByteSeq seq, byte @NotNull [] values, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (byte e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableByteSeq seq, @NotNull ByteTraversable values, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableByteSeq seq, byte element, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableByteSeq seq, byte @NotNull [] values, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        for (byte e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableByteSeq seq, @NotNull ByteTraversable values, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ByteTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableByteSeq seq, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        byte[] arr = seq.toArray();
        ByteArrays.sort((byte[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableByteSeq seq, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

