/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.ImmutableCharSeq;
import kala.collection.primitive.AbstractCharSeq;
import kala.collection.primitive.CharSeqLike;
import kala.function.CharPredicate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableCharSeq
extends AbstractCharSeq
implements ImmutableCharSeq {
    static <T, Builder> T updated(@NotNull ImmutableCharSeq seq, int index, char newValue, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        CharIterator it = seq.iterator();
        while (it.hasNext()) {
            char e = it.nextChar();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableCharSeq, Builder> T slice(@NotNull ImmutableCharSeq seq, int beginIndex, int endIndex, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableCharSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            CharIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextChar());
            }
        }
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T drop(@NotNull ImmutableCharSeq seq, int n, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        CharIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            char e = it.nextChar();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T dropLast(@NotNull ImmutableCharSeq seq, int n, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableCharSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            CharIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextChar());
            }
        }
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T dropWhile(@NotNull ImmutableCharSeq seq, @NotNull CharPredicate predicate, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T take(@NotNull ImmutableCharSeq seq, int n, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableCharSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        CharIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextChar());
        }
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T takeLast(@NotNull ImmutableCharSeq seq, int n, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableCharSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            CharIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextChar();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextChar());
            }
        }
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T takeWhile(@NotNull ImmutableCharSeq seq, @NotNull CharPredicate predicate, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T extends ImmutableCharSeq, Builder> T concat(@NotNull ImmutableCharSeq seq, @NotNull CharSeqLike other, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (CharTraversable)other);
        return (T)((ImmutableCharSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableCharSeq seq, char element, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableCharSeq seq, char @NotNull [] values, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (char e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableCharSeq seq, @NotNull CharTraversable values, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableCharSeq seq, char element, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableCharSeq seq, char @NotNull [] values, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        for (char e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableCharSeq seq, @NotNull CharTraversable values, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (CharTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableCharSeq seq, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        char[] arr = seq.toArray();
        CharArrays.sort((char[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableCharSeq seq, @NotNull CharCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

