/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import java.util.function.DoublePredicate;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.ImmutableDoubleSeq;
import kala.collection.primitive.AbstractDoubleSeq;
import kala.collection.primitive.DoubleSeqLike;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableDoubleSeq
extends AbstractDoubleSeq
implements ImmutableDoubleSeq {
    static <T, Builder> T updated(@NotNull ImmutableDoubleSeq seq, int index, double newValue, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        DoubleIterator it = seq.iterator();
        while (it.hasNext()) {
            double e = it.nextDouble();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableDoubleSeq, Builder> T slice(@NotNull ImmutableDoubleSeq seq, int beginIndex, int endIndex, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableDoubleSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            DoubleIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextDouble());
            }
        }
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T drop(@NotNull ImmutableDoubleSeq seq, int n, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        DoubleIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            double e = it.nextDouble();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T dropLast(@NotNull ImmutableDoubleSeq seq, int n, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableDoubleSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            DoubleIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextDouble());
            }
        }
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T dropWhile(@NotNull ImmutableDoubleSeq seq, @NotNull DoublePredicate predicate, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T take(@NotNull ImmutableDoubleSeq seq, int n, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableDoubleSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        DoubleIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextDouble());
        }
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T takeLast(@NotNull ImmutableDoubleSeq seq, int n, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableDoubleSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            DoubleIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextDouble();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextDouble());
            }
        }
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T takeWhile(@NotNull ImmutableDoubleSeq seq, @NotNull DoublePredicate predicate, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T extends ImmutableDoubleSeq, Builder> T concat(@NotNull ImmutableDoubleSeq seq, @NotNull DoubleSeqLike other, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (DoubleTraversable)other);
        return (T)((ImmutableDoubleSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableDoubleSeq seq, double element, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableDoubleSeq seq, double @NotNull [] values, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (double e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableDoubleSeq seq, @NotNull DoubleTraversable values, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableDoubleSeq seq, double element, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableDoubleSeq seq, double @NotNull [] values, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        for (double e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableDoubleSeq seq, @NotNull DoubleTraversable values, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (DoubleTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableDoubleSeq seq, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        double[] arr = seq.toArray();
        DoubleArrays.sort((double[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableDoubleSeq seq, @NotNull DoubleCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

