/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.ImmutableFloatCollection;
import kala.collection.primitive.AbstractFloatCollection;
import kala.function.FloatFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableFloatCollection
extends AbstractFloatCollection
implements ImmutableFloatCollection {
    static <T, Builder> T filter(@NotNull ImmutableFloatCollection collection, @NotNull FloatPredicate predicate, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableFloatCollection collection, @NotNull FloatPredicate predicate, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableFloatCollection collection, @NotNull FloatUnaryOperator mapper, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsFloat(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableFloatCollection collection, @NotNull FloatFunction<? extends FloatTraversable> mapper, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            FloatTraversable us = (FloatTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

