/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.ImmutableFloatSeq;
import kala.collection.primitive.AbstractFloatSeq;
import kala.collection.primitive.FloatSeqLike;
import kala.function.FloatPredicate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableFloatSeq
extends AbstractFloatSeq
implements ImmutableFloatSeq {
    static <T, Builder> T updated(@NotNull ImmutableFloatSeq seq, int index, float newValue, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        FloatIterator it = seq.iterator();
        while (it.hasNext()) {
            float e = it.nextFloat();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableFloatSeq, Builder> T slice(@NotNull ImmutableFloatSeq seq, int beginIndex, int endIndex, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableFloatSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            FloatIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextFloat());
            }
        }
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T drop(@NotNull ImmutableFloatSeq seq, int n, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        FloatIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            float e = it.nextFloat();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T dropLast(@NotNull ImmutableFloatSeq seq, int n, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableFloatSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            FloatIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextFloat());
            }
        }
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T dropWhile(@NotNull ImmutableFloatSeq seq, @NotNull FloatPredicate predicate, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T take(@NotNull ImmutableFloatSeq seq, int n, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableFloatSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        FloatIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextFloat());
        }
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T takeLast(@NotNull ImmutableFloatSeq seq, int n, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableFloatSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            FloatIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextFloat();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextFloat());
            }
        }
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T takeWhile(@NotNull ImmutableFloatSeq seq, @NotNull FloatPredicate predicate, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T extends ImmutableFloatSeq, Builder> T concat(@NotNull ImmutableFloatSeq seq, @NotNull FloatSeqLike other, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (FloatTraversable)other);
        return (T)((ImmutableFloatSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableFloatSeq seq, float element, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableFloatSeq seq, float @NotNull [] values, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (float e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableFloatSeq seq, @NotNull FloatTraversable values, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableFloatSeq seq, float element, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableFloatSeq seq, float @NotNull [] values, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        for (float e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableFloatSeq seq, @NotNull FloatTraversable values, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (FloatTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableFloatSeq seq, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        float[] arr = seq.toArray();
        FloatArrays.sort((float[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableFloatSeq seq, @NotNull FloatCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

