/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.immutable.primitive.ImmutableLongCollection;
import kala.collection.primitive.AbstractLongCollection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableLongCollection
extends AbstractLongCollection
implements ImmutableLongCollection {
    static <T, Builder> T filter(@NotNull ImmutableLongCollection collection, @NotNull LongPredicate predicate, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableLongCollection collection, @NotNull LongPredicate predicate, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableLongCollection collection, @NotNull LongUnaryOperator mapper, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsLong(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableLongCollection collection, @NotNull LongFunction<? extends LongTraversable> mapper, @NotNull LongCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            LongTraversable us = (LongTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

