/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.ImmutableShortSeq;
import kala.collection.primitive.AbstractShortSeq;
import kala.collection.primitive.ShortSeqLike;
import kala.function.ShortPredicate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableShortSeq
extends AbstractShortSeq
implements ImmutableShortSeq {
    static <T, Builder> T updated(@NotNull ImmutableShortSeq seq, int index, short newValue, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        ShortIterator it = seq.iterator();
        while (it.hasNext()) {
            short e = it.nextShort();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableShortSeq, Builder> T slice(@NotNull ImmutableShortSeq seq, int beginIndex, int endIndex, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableShortSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            ShortIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextShort());
            }
        }
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T drop(@NotNull ImmutableShortSeq seq, int n, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        ShortIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            short e = it.nextShort();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T dropLast(@NotNull ImmutableShortSeq seq, int n, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableShortSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            ShortIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextShort());
            }
        }
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T dropWhile(@NotNull ImmutableShortSeq seq, @NotNull ShortPredicate predicate, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T take(@NotNull ImmutableShortSeq seq, int n, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableShortSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        ShortIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextShort());
        }
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T takeLast(@NotNull ImmutableShortSeq seq, int n, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableShortSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            ShortIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextShort();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextShort());
            }
        }
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T takeWhile(@NotNull ImmutableShortSeq seq, @NotNull ShortPredicate predicate, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T extends ImmutableShortSeq, Builder> T concat(@NotNull ImmutableShortSeq seq, @NotNull ShortSeqLike other, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (ShortTraversable)other);
        return (T)((ImmutableShortSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableShortSeq seq, short element, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableShortSeq seq, short @NotNull [] values, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (short e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableShortSeq seq, @NotNull ShortTraversable values, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableShortSeq seq, short element, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableShortSeq seq, short @NotNull [] values, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        for (short e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableShortSeq seq, @NotNull ShortTraversable values, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (ShortTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableShortSeq seq, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        short[] arr = seq.toArray();
        ShortArrays.sort((short[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableShortSeq seq, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

