/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.immutable.primitive.ImmutableByteSet;
import kala.collection.mutable.primitive.MutableByteSet;
import kala.collection.primitive.AbstractDefaultByteSet;
import org.jetbrains.annotations.NotNull;

final class DefaultImmutableByteSet
extends AbstractDefaultByteSet
implements ImmutableByteSet {
    private static final long serialVersionUID = 6028841354144450491L;
    private static final Factory FACTORY = new Factory();
    static final DefaultImmutableByteSet EMPTY = new DefaultImmutableByteSet(0, 0L, 0L, 0L, 0L);

    DefaultImmutableByteSet(int size, long bits0, long bits1, long bits2, long bits3) {
        this.size = size;
        this.bits0 = bits0;
        this.bits1 = bits1;
        this.bits2 = bits2;
        this.bits3 = bits3;
    }

    static ByteCollectionFactory<?, DefaultImmutableByteSet> factory() {
        return FACTORY;
    }

    @NotNull
    static DefaultImmutableByteSet empty() {
        return EMPTY;
    }

    @NotNull
    static DefaultImmutableByteSet of() {
        return EMPTY;
    }

    @NotNull
    static DefaultImmutableByteSet of(byte value1) {
        MutableByteSet builder = FACTORY.newBuilder();
        builder.add(value1);
        return FACTORY.build(builder);
    }

    @NotNull
    static DefaultImmutableByteSet of(byte value1, byte value2) {
        MutableByteSet builder = FACTORY.newBuilder();
        builder.add(value1);
        builder.add(value2);
        return FACTORY.build(builder);
    }

    @NotNull
    static DefaultImmutableByteSet of(byte value1, byte value2, byte value3) {
        MutableByteSet builder = FACTORY.newBuilder();
        builder.add(value1);
        builder.add(value2);
        builder.add(value3);
        return FACTORY.build(builder);
    }

    @NotNull
    static DefaultImmutableByteSet of(byte value1, byte value2, byte value3, byte value4) {
        MutableByteSet builder = FACTORY.newBuilder();
        builder.add(value1);
        builder.add(value2);
        builder.add(value3);
        builder.add(value4);
        return FACTORY.build(builder);
    }

    @NotNull
    static DefaultImmutableByteSet of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        MutableByteSet builder = FACTORY.newBuilder();
        builder.add(value1);
        builder.add(value2);
        builder.add(value3);
        builder.add(value4);
        builder.add(value5);
        return FACTORY.build(builder);
    }

    @NotNull
    static DefaultImmutableByteSet of(byte ... values) {
        return DefaultImmutableByteSet.from(values);
    }

    @NotNull
    static DefaultImmutableByteSet from(byte @NotNull [] values) {
        if (values.length == 0) {
            return EMPTY;
        }
        MutableByteSet builder = FACTORY.newBuilder();
        builder.addAll(values);
        return FACTORY.build(builder);
    }

    @NotNull
    static DefaultImmutableByteSet from(@NotNull ByteTraversable values) {
        return DefaultImmutableByteSet.from(values.iterator());
    }

    @NotNull
    static DefaultImmutableByteSet from(@NotNull ByteIterator it) {
        if (!it.hasNext()) {
            return EMPTY;
        }
        MutableByteSet builder = FACTORY.newBuilder();
        while (it.hasNext()) {
            builder.add(it.nextByte());
        }
        return FACTORY.build(builder);
    }

    @Override
    @NotNull
    public ImmutableByteSet added(byte value) {
        int v = value + 128;
        int bitsNumber = v / 64;
        int bitOffset = v % 64;
        long bits = switch (bitsNumber) {
            case 0 -> this.bits0;
            case 1 -> this.bits1;
            case 2 -> this.bits2;
            case 3 -> this.bits3;
            default -> throw new AssertionError();
        };
        long newBits = bits | 1L << bitOffset;
        if (newBits == bits) {
            return this;
        }
        return switch (bitsNumber) {
            case 0 -> new DefaultImmutableByteSet(this.size + 1, newBits, this.bits1, this.bits2, this.bits3);
            case 1 -> new DefaultImmutableByteSet(this.size + 1, this.bits0, newBits, this.bits2, this.bits3);
            case 2 -> new DefaultImmutableByteSet(this.size + 1, this.bits0, this.bits1, newBits, this.bits3);
            case 3 -> new DefaultImmutableByteSet(this.size + 1, this.bits0, this.bits1, this.bits2, newBits);
            default -> throw new AssertionError();
        };
    }

    private Object readResolve() {
        if (this.size == 0) {
            return EMPTY;
        }
        return this;
    }

    private static final class Factory
    implements ByteCollectionFactory<MutableByteSet, DefaultImmutableByteSet> {
        private Factory() {
        }

        public MutableByteSet newBuilder() {
            return MutableByteSet.create();
        }

        public void addToBuilder(@NotNull MutableByteSet builder, byte value) {
            builder.add(value);
        }

        public MutableByteSet mergeBuilder(@NotNull MutableByteSet builder1, @NotNull MutableByteSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }

        public DefaultImmutableByteSet build(MutableByteSet builder) {
            AbstractDefaultByteSet set = (AbstractDefaultByteSet)((Object)builder);
            return set.isEmpty() ? EMPTY : new DefaultImmutableByteSet(set.size(), set.bits0(), set.bits1(), set.bits2(), set.bits3());
        }
    }
}

