/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Arrays;
import java.util.function.BooleanSupplier;
import kala.NotImplementedError;
import kala.collection.base.primitive.BitArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanSeq;
import kala.collection.primitive.BitArray;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class ImmutableBitArray
extends BitArray
implements ImmutableBooleanSeq {
    private static final ImmutableBitArray EMPTY = new ImmutableBitArray(0L, 0);

    private ImmutableBitArray(long[] bitsArray, int size) {
        super(bitsArray, size);
    }

    private ImmutableBitArray(long bits, int size) {
        super(bits, size);
    }

    @NotNull
    public static BooleanCollectionFactory<?, ? extends ImmutableBitArray> factory() {
        throw new NotImplementedError();
    }

    @NotNull
    public static ImmutableBitArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableBitArray of() {
        return ImmutableBitArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableBitArray of(boolean value1) {
        long bits = 0L;
        bits = BitArrays.set((long)bits, (int)0, (boolean)value1);
        return new ImmutableBitArray(bits, 1);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableBitArray of(boolean value1, boolean value2) {
        long bits = 0L;
        bits = BitArrays.set((long)bits, (int)0, (boolean)value1);
        bits = BitArrays.set((long)bits, (int)1, (boolean)value2);
        return new ImmutableBitArray(bits, 2);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableBitArray of(boolean value1, boolean value2, boolean value3) {
        long bits = 0L;
        bits = BitArrays.set((long)bits, (int)0, (boolean)value1);
        bits = BitArrays.set((long)bits, (int)1, (boolean)value2);
        bits = BitArrays.set((long)bits, (int)2, (boolean)value3);
        return new ImmutableBitArray(bits, 3);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableBitArray of(boolean value1, boolean value2, boolean value3, boolean value4) {
        long bits = 0L;
        bits = BitArrays.set((long)bits, (int)0, (boolean)value1);
        bits = BitArrays.set((long)bits, (int)1, (boolean)value2);
        bits = BitArrays.set((long)bits, (int)2, (boolean)value3);
        bits = BitArrays.set((long)bits, (int)3, (boolean)value4);
        return new ImmutableBitArray(bits, 4);
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableBitArray of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        long bits = 0L;
        bits = BitArrays.set((long)bits, (int)0, (boolean)value1);
        bits = BitArrays.set((long)bits, (int)1, (boolean)value2);
        bits = BitArrays.set((long)bits, (int)2, (boolean)value3);
        bits = BitArrays.set((long)bits, (int)3, (boolean)value4);
        bits = BitArrays.set((long)bits, (int)4, (boolean)value5);
        return new ImmutableBitArray(bits, 5);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableBitArray of(boolean ... values) {
        return ImmutableBitArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableBitArray from(boolean @NotNull [] values) {
        int size = values.length;
        if (size == 0) {
            return ImmutableBitArray.empty();
        }
        if (size <= 64) {
            long bits = 0L;
            for (int i = 0; i < size; ++i) {
                bits = BitArrays.set((long)bits, (int)i, (boolean)values[i]);
            }
            return new ImmutableBitArray(bits, size);
        }
        int fullChunkCount = size / 64;
        int notFullChunkLength = size % 64;
        long[] bitsArray = new long[notFullChunkLength > 0 ? fullChunkCount + 1 : fullChunkCount];
        for (int i = 0; i < fullChunkCount; ++i) {
            int baseIndex = i * 64;
            long bits = 0L;
            for (int j = 0; j < 64; ++j) {
                bits = BitArrays.set((long)bits, (int)j, (boolean)values[baseIndex + j]);
            }
            bitsArray[i] = bits;
        }
        if (notFullChunkLength > 0) {
            int baseIndex = fullChunkCount * 64;
            long bits = 0L;
            for (int i = 0; i < notFullChunkLength; ++i) {
                bits = BitArrays.set((long)bits, (int)i, (boolean)values[baseIndex + i]);
            }
            bitsArray[fullChunkCount] = bits;
        }
        return new ImmutableBitArray(bitsArray, size);
    }

    @NotNull
    public static ImmutableBitArray from(@NotNull BooleanTraversable values) {
        if (values instanceof ImmutableBitArray) {
            ImmutableBitArray ba = (ImmutableBitArray)values;
            return ba;
        }
        if (values.isEmpty()) {
            return ImmutableBitArray.empty();
        }
        throw new NotImplementedError();
    }

    @NotNull
    public static ImmutableBitArray from(@NotNull BooleanIterator it) {
        if (!it.hasNext()) {
            return ImmutableBitArray.empty();
        }
        throw new NotImplementedError();
    }

    @NotNull
    public static ImmutableBitArray fill(int n, boolean value) {
        if (n <= 0) {
            return ImmutableBitArray.empty();
        }
        if (n <= 64) {
            if (value) {
                long bits = 0L;
                for (int i = 0; i < n; ++i) {
                    bits = BitArrays.set((long)bits, (int)i, (boolean)true);
                }
                return new ImmutableBitArray(bits, n);
            }
            return new ImmutableBitArray(0L, n);
        }
        int fullChunkCount = n / 64;
        int notFullChunkLength = n % 64;
        long[] bitsArray = new long[notFullChunkLength > 0 ? fullChunkCount + 1 : fullChunkCount];
        if (value) {
            Arrays.fill(bitsArray, -1L);
        }
        return new ImmutableBitArray(bitsArray, n);
    }

    @NotNull
    public static ImmutableBitArray fill(int n, @NotNull BooleanSupplier supplier) {
        if (n <= 0) {
            return ImmutableBitArray.empty();
        }
        throw new NotImplementedError();
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableBitArray";
    }
}

