/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanSeq;
import kala.collection.mutable.primitive.MutableBooleanArrayList;
import kala.collection.primitive.BooleanArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableBooleanArray
extends BooleanArraySeq
implements ImmutableBooleanSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableBooleanArray EMPTY = new ImmutableBooleanArray(BooleanArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableBooleanArray(boolean @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static BooleanCollectionFactory<?, ? extends ImmutableBooleanArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableBooleanArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableBooleanArray of() {
        return ImmutableBooleanArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableBooleanArray of(boolean value1) {
        return new ImmutableBooleanArray(new boolean[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableBooleanArray of(boolean value1, boolean value2) {
        return new ImmutableBooleanArray(new boolean[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableBooleanArray of(boolean value1, boolean value2, boolean value3) {
        return new ImmutableBooleanArray(new boolean[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableBooleanArray of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return new ImmutableBooleanArray(new boolean[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableBooleanArray of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return new ImmutableBooleanArray(new boolean[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableBooleanArray of(boolean ... values) {
        return ImmutableBooleanArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableBooleanArray from(boolean @NotNull [] values) {
        return values.length == 0 ? ImmutableBooleanArray.empty() : new ImmutableBooleanArray((boolean[])values.clone());
    }

    @NotNull
    public static ImmutableBooleanArray from(@NotNull BooleanTraversable values) {
        if (values instanceof ImmutableBooleanArray) {
            return (ImmutableBooleanArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableBooleanArray.empty();
        }
        boolean[] arr = values.toArray();
        return arr.length == 0 ? ImmutableBooleanArray.empty() : new ImmutableBooleanArray(arr);
    }

    @NotNull
    public static ImmutableBooleanArray from(@NotNull BooleanIterator it) {
        if (!it.hasNext()) {
            return ImmutableBooleanArray.empty();
        }
        return new ImmutableBooleanArray(it.toArray());
    }

    @NotNull
    public static ImmutableBooleanArray fill(int n, boolean value) {
        if (n <= 0) {
            return ImmutableBooleanArray.empty();
        }
        boolean[] ans = new boolean[n];
        if (value) {
            Arrays.fill(ans, value);
        }
        return new ImmutableBooleanArray(ans);
    }

    @NotNull
    public static ImmutableBooleanArray fill(int n, @NotNull BooleanSupplier supplier) {
        if (n <= 0) {
            return ImmutableBooleanArray.empty();
        }
        boolean[] ans = new boolean[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsBoolean();
        }
        return new ImmutableBooleanArray(ans);
    }

    boolean @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableBooleanArray";
    }

    private static final class Factory
    implements BooleanCollectionFactory<MutableBooleanArrayList, ImmutableBooleanArray> {
        private Factory() {
        }

        public ImmutableBooleanArray empty() {
            return ImmutableBooleanArray.empty();
        }

        public ImmutableBooleanArray from(boolean @NotNull [] values) {
            return ImmutableBooleanArray.from(values);
        }

        public ImmutableBooleanArray from(@NotNull BooleanTraversable values) {
            return ImmutableBooleanArray.from(values);
        }

        public ImmutableBooleanArray from(@NotNull BooleanIterator it) {
            return ImmutableBooleanArray.from(it);
        }

        public ImmutableBooleanArray fill(int n, boolean value) {
            return ImmutableBooleanArray.fill(n, value);
        }

        public ImmutableBooleanArray fill(int n, @NotNull BooleanSupplier supplier) {
            return ImmutableBooleanArray.fill(n, supplier);
        }

        public MutableBooleanArrayList newBuilder() {
            return new MutableBooleanArrayList();
        }

        public void addToBuilder(@NotNull MutableBooleanArrayList buffer, boolean value) {
            buffer.append(value);
        }

        public MutableBooleanArrayList mergeBuilder(@NotNull MutableBooleanArrayList builder1, @NotNull MutableBooleanArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableBooleanArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableBooleanArray build(@NotNull MutableBooleanArrayList buffer) {
            return new ImmutableBooleanArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableBooleanArray wrap(boolean @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableBooleanArray(array);
        }
    }
}

