/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableCharCollection;
import kala.collection.immutable.primitive.AbstractImmutableCharSet;
import kala.collection.immutable.primitive.ImmutableCharCollection;
import kala.collection.immutable.primitive.ImmutablePrimitiveSet;
import kala.collection.immutable.primitive.ImmutableSortedCharArraySet;
import kala.collection.primitive.CharArraySeq;
import kala.collection.primitive.CharSet;
import kala.function.CharPredicate;
import org.jetbrains.annotations.NotNull;

public interface ImmutableCharSet
extends ImmutablePrimitiveSet<Character>,
CharSet,
ImmutableCharCollection {
    public static CharCollectionFactory<?, ImmutableCharSet> factory() {
        return CharCollectionFactory.narrow(ImmutableSortedCharArraySet.factory());
    }

    @NotNull
    public static ImmutableCharSet empty() {
        return ImmutableSortedCharArraySet.empty();
    }

    @NotNull
    public static ImmutableCharSet of() {
        return ImmutableSortedCharArraySet.of();
    }

    @NotNull
    public static ImmutableCharSet of(char value1) {
        return ImmutableSortedCharArraySet.of(value1);
    }

    @NotNull
    public static ImmutableCharSet of(char value1, char value2) {
        return ImmutableSortedCharArraySet.of(value1, value2);
    }

    @NotNull
    public static ImmutableCharSet of(char value1, char value2, char value3) {
        return ImmutableSortedCharArraySet.of(value1, value2, value3);
    }

    @NotNull
    public static ImmutableCharSet of(char value1, char value2, char value3, char value4) {
        return ImmutableSortedCharArraySet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ImmutableCharSet of(char value1, char value2, char value3, char value4, char value5) {
        return ImmutableSortedCharArraySet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ImmutableCharSet of(char ... values) {
        return ImmutableSortedCharArraySet.of(values);
    }

    @NotNull
    public static ImmutableCharSet from(char @NotNull [] values) {
        return ImmutableSortedCharArraySet.from(values);
    }

    @NotNull
    public static ImmutableCharSet from(@NotNull CharTraversable values) {
        return ImmutableSortedCharArraySet.from(values);
    }

    @NotNull
    public static ImmutableCharSet from(@NotNull CharIterator it) {
        return ImmutableSortedCharArraySet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableCharSet";
    }

    @NotNull
    default public CharCollectionFactory<?, ? extends ImmutableCharSet> iterableFactory() {
        return ImmutableCharSet.factory();
    }

    @NotNull
    default public ImmutableCharSet added(char value) {
        if (this.contains(value)) {
            return this;
        }
        return AbstractImmutableCharSet.added(this, value, this.iterableFactory());
    }

    @NotNull
    default public ImmutableCharSet addedAll(@NotNull CharTraversable values) {
        return AbstractImmutableCharSet.addedAll(this, values, this.iterableFactory());
    }

    @NotNull
    default public ImmutableCharSet addedAll(char @NotNull [] values) {
        return this.addedAll(CharArraySeq.wrap(values));
    }

    @Override
    @NotNull
    default public ImmutableCharSet filter(@NotNull CharPredicate predicate) {
        return AbstractImmutableCharCollection.filter(this, predicate, ImmutableCharSet.factory());
    }

    @Override
    @NotNull
    default public ImmutableCharSet filterNot(@NotNull CharPredicate predicate) {
        return AbstractImmutableCharCollection.filterNot(this, predicate, ImmutableCharSet.factory());
    }
}

