/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.function.DoublePredicate;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableDoubleCollection;
import kala.collection.immutable.primitive.AbstractImmutableDoubleSet;
import kala.collection.immutable.primitive.ImmutableDoubleCollection;
import kala.collection.immutable.primitive.ImmutablePrimitiveSet;
import kala.collection.immutable.primitive.ImmutableSortedDoubleArraySet;
import kala.collection.primitive.DoubleArraySeq;
import kala.collection.primitive.DoubleSet;
import org.jetbrains.annotations.NotNull;

public interface ImmutableDoubleSet
extends ImmutablePrimitiveSet<Double>,
DoubleSet,
ImmutableDoubleCollection {
    public static DoubleCollectionFactory<?, ImmutableDoubleSet> factory() {
        return DoubleCollectionFactory.narrow(ImmutableSortedDoubleArraySet.factory());
    }

    @NotNull
    public static ImmutableDoubleSet empty() {
        return ImmutableSortedDoubleArraySet.empty();
    }

    @NotNull
    public static ImmutableDoubleSet of() {
        return ImmutableSortedDoubleArraySet.of();
    }

    @NotNull
    public static ImmutableDoubleSet of(double value1) {
        return ImmutableSortedDoubleArraySet.of(value1);
    }

    @NotNull
    public static ImmutableDoubleSet of(double value1, double value2) {
        return ImmutableSortedDoubleArraySet.of(value1, value2);
    }

    @NotNull
    public static ImmutableDoubleSet of(double value1, double value2, double value3) {
        return ImmutableSortedDoubleArraySet.of(value1, value2, value3);
    }

    @NotNull
    public static ImmutableDoubleSet of(double value1, double value2, double value3, double value4) {
        return ImmutableSortedDoubleArraySet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ImmutableDoubleSet of(double value1, double value2, double value3, double value4, double value5) {
        return ImmutableSortedDoubleArraySet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ImmutableDoubleSet of(double ... values) {
        return ImmutableSortedDoubleArraySet.of(values);
    }

    @NotNull
    public static ImmutableDoubleSet from(double @NotNull [] values) {
        return ImmutableSortedDoubleArraySet.from(values);
    }

    @NotNull
    public static ImmutableDoubleSet from(@NotNull DoubleTraversable values) {
        return ImmutableSortedDoubleArraySet.from(values);
    }

    @NotNull
    public static ImmutableDoubleSet from(@NotNull DoubleIterator it) {
        return ImmutableSortedDoubleArraySet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableDoubleSet";
    }

    @NotNull
    default public DoubleCollectionFactory<?, ? extends ImmutableDoubleSet> iterableFactory() {
        return ImmutableDoubleSet.factory();
    }

    @NotNull
    default public ImmutableDoubleSet added(double value) {
        if (this.contains(value)) {
            return this;
        }
        return AbstractImmutableDoubleSet.added(this, value, this.iterableFactory());
    }

    @NotNull
    default public ImmutableDoubleSet addedAll(@NotNull DoubleTraversable values) {
        return AbstractImmutableDoubleSet.addedAll(this, values, this.iterableFactory());
    }

    @NotNull
    default public ImmutableDoubleSet addedAll(double @NotNull [] values) {
        return this.addedAll(DoubleArraySeq.wrap(values));
    }

    @Override
    @NotNull
    default public ImmutableDoubleSet filter(@NotNull DoublePredicate predicate) {
        return AbstractImmutableDoubleCollection.filter(this, predicate, ImmutableDoubleSet.factory());
    }

    @Override
    @NotNull
    default public ImmutableDoubleSet filterNot(@NotNull DoublePredicate predicate) {
        return AbstractImmutableDoubleCollection.filterNot(this, predicate, ImmutableDoubleSet.factory());
    }
}

