/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.ImmutableCollection;
import kala.collection.immutable.primitive.AbstractImmutableIntCollection;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.immutable.primitive.ImmutablePrimitiveCollection;
import kala.collection.primitive.IntCollection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ImmutableIntCollection
extends ImmutablePrimitiveCollection<Integer>,
IntCollection {
    @NotNull
    public static IntCollectionFactory<?, ImmutableIntCollection> factory() {
        return IntCollectionFactory.narrow(ImmutableIntSeq.factory());
    }

    @NotNull
    public static ImmutableIntCollection empty() {
        return ImmutableIntSeq.empty();
    }

    @NotNull
    public static ImmutableIntCollection of() {
        return ImmutableIntSeq.of();
    }

    @NotNull
    public static ImmutableIntCollection of(int value1) {
        return ImmutableIntSeq.of(value1);
    }

    @NotNull
    public static ImmutableIntCollection of(int value1, int value2) {
        return ImmutableIntSeq.of(value1, value2);
    }

    @NotNull
    public static ImmutableIntCollection of(int value1, int value2, int value3) {
        return ImmutableIntSeq.of(value1, value2, value3);
    }

    @NotNull
    public static ImmutableIntCollection of(int value1, int value2, int value3, int value4) {
        return ImmutableIntSeq.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ImmutableIntCollection of(int value1, int value2, int value3, int value4, int value5) {
        return ImmutableIntSeq.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ImmutableIntCollection of(int ... values) {
        return ImmutableIntSeq.of(values);
    }

    @NotNull
    public static ImmutableIntCollection from(int @NotNull [] values) {
        return ImmutableIntSeq.from(values);
    }

    @NotNull
    public static ImmutableIntCollection from(@NotNull IntTraversable values) {
        return ImmutableIntSeq.from(values);
    }

    @NotNull
    public static ImmutableIntCollection from(@NotNull IntIterator it) {
        return ImmutableIntSeq.from(it);
    }

    @NotNull
    public static ImmutableIntCollection fill(int n, int value) {
        return ImmutableIntSeq.fill(n, value);
    }

    @NotNull
    public static ImmutableIntCollection fill(int n, @NotNull IntSupplier supplier) {
        return ImmutableIntSeq.fill(n, supplier);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableIntCollection";
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends ImmutableIntCollection> iterableFactory() {
        return ImmutableIntCollection.factory();
    }

    @Override
    @NotNull
    default public ImmutableIntCollection filter(@NotNull IntPredicate predicate) {
        return AbstractImmutableIntCollection.filter(this, predicate, this.iterableFactory());
    }

    @Override
    @NotNull
    default public ImmutableIntCollection filterNot(@NotNull IntPredicate predicate) {
        return AbstractImmutableIntCollection.filterNot(this, predicate, this.iterableFactory());
    }

    @Override
    @NotNull
    default public ImmutableIntCollection map(@NotNull IntUnaryOperator mapper) {
        return AbstractImmutableIntCollection.map(this, mapper, this.iterableFactory());
    }

    @Override
    @NotNull
    default public <U> ImmutableCollection<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
        return IntCollection.super.mapToObj(mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntCollection flatMap(@NotNull IntFunction<? extends IntTraversable> mapper) {
        return AbstractImmutableIntCollection.flatMap(this, mapper, this.iterableFactory());
    }
}

