/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.function.IntPredicate;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableIntCollection;
import kala.collection.immutable.primitive.AbstractImmutableIntSet;
import kala.collection.immutable.primitive.ImmutableIntCollection;
import kala.collection.immutable.primitive.ImmutablePrimitiveSet;
import kala.collection.immutable.primitive.ImmutableSortedIntArraySet;
import kala.collection.primitive.IntArraySeq;
import kala.collection.primitive.IntSet;
import org.jetbrains.annotations.NotNull;

public interface ImmutableIntSet
extends ImmutablePrimitiveSet<Integer>,
IntSet,
ImmutableIntCollection {
    public static IntCollectionFactory<?, ImmutableIntSet> factory() {
        return IntCollectionFactory.narrow(ImmutableSortedIntArraySet.factory());
    }

    @NotNull
    public static ImmutableIntSet empty() {
        return ImmutableSortedIntArraySet.empty();
    }

    @NotNull
    public static ImmutableIntSet of() {
        return ImmutableSortedIntArraySet.of();
    }

    @NotNull
    public static ImmutableIntSet of(int value1) {
        return ImmutableSortedIntArraySet.of(value1);
    }

    @NotNull
    public static ImmutableIntSet of(int value1, int value2) {
        return ImmutableSortedIntArraySet.of(value1, value2);
    }

    @NotNull
    public static ImmutableIntSet of(int value1, int value2, int value3) {
        return ImmutableSortedIntArraySet.of(value1, value2, value3);
    }

    @NotNull
    public static ImmutableIntSet of(int value1, int value2, int value3, int value4) {
        return ImmutableSortedIntArraySet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static ImmutableIntSet of(int value1, int value2, int value3, int value4, int value5) {
        return ImmutableSortedIntArraySet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static ImmutableIntSet of(int ... values) {
        return ImmutableSortedIntArraySet.of(values);
    }

    @NotNull
    public static ImmutableIntSet from(int @NotNull [] values) {
        return ImmutableSortedIntArraySet.from(values);
    }

    @NotNull
    public static ImmutableIntSet from(@NotNull IntTraversable values) {
        return ImmutableSortedIntArraySet.from(values);
    }

    @NotNull
    public static ImmutableIntSet from(@NotNull IntIterator it) {
        return ImmutableSortedIntArraySet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableIntSet";
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends ImmutableIntSet> iterableFactory() {
        return ImmutableIntSet.factory();
    }

    @NotNull
    default public ImmutableIntSet added(int value) {
        if (this.contains(value)) {
            return this;
        }
        return AbstractImmutableIntSet.added(this, value, this.iterableFactory());
    }

    @NotNull
    default public ImmutableIntSet addedAll(@NotNull IntTraversable values) {
        return AbstractImmutableIntSet.addedAll(this, values, this.iterableFactory());
    }

    @NotNull
    default public ImmutableIntSet addedAll(int @NotNull [] values) {
        return this.addedAll(IntArraySeq.wrap(values));
    }

    @Override
    @NotNull
    default public ImmutableIntSet filter(@NotNull IntPredicate predicate) {
        return AbstractImmutableIntCollection.filter(this, predicate, ImmutableIntSet.factory());
    }

    @Override
    @NotNull
    default public ImmutableIntSet filterNot(@NotNull IntPredicate predicate) {
        return AbstractImmutableIntCollection.filterNot(this, predicate, ImmutableIntSet.factory());
    }
}

