/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.LongSupplier;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.immutable.primitive.ImmutableLongSeq;
import kala.collection.mutable.primitive.MutableLongArrayList;
import kala.collection.primitive.LongArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableLongArray
extends LongArraySeq
implements ImmutableLongSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableLongArray EMPTY = new ImmutableLongArray(LongArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableLongArray(long @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static LongCollectionFactory<?, ? extends ImmutableLongArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableLongArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableLongArray of() {
        return ImmutableLongArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableLongArray of(long value1) {
        return new ImmutableLongArray(new long[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableLongArray of(long value1, long value2) {
        return new ImmutableLongArray(new long[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableLongArray of(long value1, long value2, long value3) {
        return new ImmutableLongArray(new long[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableLongArray of(long value1, long value2, long value3, long value4) {
        return new ImmutableLongArray(new long[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableLongArray of(long value1, long value2, long value3, long value4, long value5) {
        return new ImmutableLongArray(new long[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableLongArray of(long ... values) {
        return ImmutableLongArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableLongArray from(long @NotNull [] values) {
        return values.length == 0 ? ImmutableLongArray.empty() : new ImmutableLongArray((long[])values.clone());
    }

    @NotNull
    public static ImmutableLongArray from(@NotNull LongTraversable values) {
        if (values instanceof ImmutableLongArray) {
            return (ImmutableLongArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableLongArray.empty();
        }
        long[] arr = values.toArray();
        return arr.length == 0 ? ImmutableLongArray.empty() : new ImmutableLongArray(arr);
    }

    @NotNull
    public static ImmutableLongArray from(@NotNull LongIterator it) {
        if (!it.hasNext()) {
            return ImmutableLongArray.empty();
        }
        return new ImmutableLongArray(it.toArray());
    }

    @NotNull
    public static ImmutableLongArray fill(int n, long value) {
        if (n <= 0) {
            return ImmutableLongArray.empty();
        }
        long[] ans = new long[n];
        if (value != 0L) {
            Arrays.fill(ans, value);
        }
        return new ImmutableLongArray(ans);
    }

    @NotNull
    public static ImmutableLongArray fill(int n, @NotNull LongSupplier supplier) {
        if (n <= 0) {
            return ImmutableLongArray.empty();
        }
        long[] ans = new long[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsLong();
        }
        return new ImmutableLongArray(ans);
    }

    long @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableLongArray";
    }

    @NotNull
    public Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.elements, 1024);
    }

    private static final class Factory
    implements LongCollectionFactory<MutableLongArrayList, ImmutableLongArray> {
        private Factory() {
        }

        public ImmutableLongArray empty() {
            return ImmutableLongArray.empty();
        }

        public ImmutableLongArray from(long @NotNull [] values) {
            return ImmutableLongArray.from(values);
        }

        public ImmutableLongArray from(@NotNull LongTraversable values) {
            return ImmutableLongArray.from(values);
        }

        public ImmutableLongArray from(@NotNull LongIterator it) {
            return ImmutableLongArray.from(it);
        }

        public ImmutableLongArray fill(int n, long value) {
            return ImmutableLongArray.fill(n, value);
        }

        public ImmutableLongArray fill(int n, @NotNull LongSupplier supplier) {
            return ImmutableLongArray.fill(n, supplier);
        }

        public MutableLongArrayList newBuilder() {
            return new MutableLongArrayList();
        }

        public void addToBuilder(@NotNull MutableLongArrayList buffer, long value) {
            buffer.append(value);
        }

        public MutableLongArrayList mergeBuilder(@NotNull MutableLongArrayList builder1, @NotNull MutableLongArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableLongArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableLongArray build(@NotNull MutableLongArrayList buffer) {
            return new ImmutableLongArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableLongArray wrap(long @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableLongArray(array);
        }
    }
}

