/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableCharSet;
import kala.collection.mutable.primitive.MutableCharTreeSet;
import kala.function.CharConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableSortedCharArraySet
extends AbstractImmutableCharSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final ImmutableSortedCharArraySet EMPTY = new ImmutableSortedCharArraySet(CharArrays.EMPTY);
    final char[] elements;

    ImmutableSortedCharArraySet(char[] elements) {
        this.elements = elements;
    }

    @NotNull
    public static CharCollectionFactory<?, ImmutableSortedCharArraySet> factory() {
        return FACTORY;
    }

    @Contract
    @NotNull
    public static ImmutableSortedCharArraySet empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableSortedCharArraySet of() {
        return ImmutableSortedCharArraySet.empty();
    }

    @NotNull
    public static ImmutableSortedCharArraySet of(char value1) {
        return new ImmutableSortedCharArraySet(new char[]{value1});
    }

    @NotNull
    public static ImmutableSortedCharArraySet of(char value1, char value2) {
        int c = Character.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedCharArraySet(new char[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedCharArraySet(new char[]{value2, value1});
        }
        return new ImmutableSortedCharArraySet(new char[]{value1});
    }

    @NotNull
    public static ImmutableSortedCharArraySet of(char value1, char value2, char value3) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedCharArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedCharArraySet of(char value1, char value2, char value3, char value4) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedCharArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedCharArraySet of(char value1, char value2, char value3, char value4, char value5) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedCharArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedCharArraySet of(char ... values) {
        return ImmutableSortedCharArraySet.from(values);
    }

    @NotNull
    public static ImmutableSortedCharArraySet from(char @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedCharArraySet.empty();
        }
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.addAll(values);
        return new ImmutableSortedCharArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedCharArraySet from(@NotNull CharTraversable values) {
        return ImmutableSortedCharArraySet.from(values.iterator());
    }

    @NotNull
    public static ImmutableSortedCharArraySet from(@NotNull CharIterator it) {
        if (!it.hasNext()) {
            return ImmutableSortedCharArraySet.empty();
        }
        MutableCharTreeSet s = new MutableCharTreeSet();
        while (it.hasNext()) {
            s.add(it.nextChar());
        }
        return new ImmutableSortedCharArraySet(s.toArray());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedCharArraySet";
    }

    @NotNull
    public CharCollectionFactory<?, ImmutableSortedCharArraySet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public CharIterator iterator() {
        return CharArrays.iterator((char[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedCharArraySet added(char value) {
        int size = this.elements.length;
        if (size == 0) {
            return new ImmutableSortedCharArraySet(new char[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        char[] newElements = new char[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedCharArraySet(newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedCharArraySet(newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedCharArraySet(newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedCharArraySet addedAll(@NotNull CharTraversable values) {
        CharIterator it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        char[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedCharArraySet.from(values);
        }
        MutableCharTreeSet builder = new MutableCharTreeSet();
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedCharArraySet(builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedCharArraySet addedAll(char @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added(values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedCharArraySet.from(values);
        }
        MutableCharTreeSet builder = new MutableCharTreeSet();
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedCharArraySet(builder.toArray());
    }

    public char getFirst() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    public char getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)CharArrays.joinTo((char[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull CharConsumer action) {
        for (char e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory
    implements CharCollectionFactory<MutableCharTreeSet, ImmutableSortedCharArraySet> {
        private Factory() {
        }

        public ImmutableSortedCharArraySet empty() {
            return ImmutableSortedCharArraySet.empty();
        }

        public MutableCharTreeSet newBuilder() {
            return new MutableCharTreeSet();
        }

        public ImmutableSortedCharArraySet build(@NotNull MutableCharTreeSet builder) {
            return builder.isEmpty() ? ImmutableSortedCharArraySet.empty() : new ImmutableSortedCharArraySet(builder.toArray());
        }

        public void addToBuilder(@NotNull MutableCharTreeSet builder, char value) {
            builder.add(value);
        }

        public MutableCharTreeSet mergeBuilder(@NotNull MutableCharTreeSet builder1, @NotNull MutableCharTreeSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

