/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableFloatSet;
import kala.collection.mutable.primitive.MutableFloatTreeSet;
import kala.function.FloatConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableSortedFloatArraySet
extends AbstractImmutableFloatSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final ImmutableSortedFloatArraySet EMPTY = new ImmutableSortedFloatArraySet(FloatArrays.EMPTY);
    final float[] elements;

    ImmutableSortedFloatArraySet(float[] elements) {
        this.elements = elements;
    }

    @NotNull
    public static FloatCollectionFactory<?, ImmutableSortedFloatArraySet> factory() {
        return FACTORY;
    }

    @Contract
    @NotNull
    public static ImmutableSortedFloatArraySet empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of() {
        return ImmutableSortedFloatArraySet.empty();
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of(float value1) {
        return new ImmutableSortedFloatArraySet(new float[]{value1});
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of(float value1, float value2) {
        int c = Float.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedFloatArraySet(new float[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedFloatArraySet(new float[]{value2, value1});
        }
        return new ImmutableSortedFloatArraySet(new float[]{value1});
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of(float value1, float value2, float value3) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedFloatArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of(float value1, float value2, float value3, float value4) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedFloatArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of(float value1, float value2, float value3, float value4, float value5) {
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedFloatArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedFloatArraySet of(float ... values) {
        return ImmutableSortedFloatArraySet.from(values);
    }

    @NotNull
    public static ImmutableSortedFloatArraySet from(float @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedFloatArraySet.empty();
        }
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        s.addAll(values);
        return new ImmutableSortedFloatArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedFloatArraySet from(@NotNull FloatTraversable values) {
        return ImmutableSortedFloatArraySet.from(values.iterator());
    }

    @NotNull
    public static ImmutableSortedFloatArraySet from(@NotNull FloatIterator it) {
        if (!it.hasNext()) {
            return ImmutableSortedFloatArraySet.empty();
        }
        MutableFloatTreeSet s = new MutableFloatTreeSet();
        while (it.hasNext()) {
            s.add(it.nextFloat());
        }
        return new ImmutableSortedFloatArraySet(s.toArray());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedFloatArraySet";
    }

    @NotNull
    public FloatCollectionFactory<?, ImmutableSortedFloatArraySet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public FloatIterator iterator() {
        return FloatArrays.iterator((float[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedFloatArraySet added(float value) {
        int size = this.elements.length;
        if (size == 0) {
            return new ImmutableSortedFloatArraySet(new float[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        float[] newElements = new float[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedFloatArraySet(newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedFloatArraySet(newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedFloatArraySet(newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedFloatArraySet addedAll(@NotNull FloatTraversable values) {
        FloatIterator it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        float[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedFloatArraySet.from(values);
        }
        MutableFloatTreeSet builder = new MutableFloatTreeSet();
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedFloatArraySet(builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedFloatArraySet addedAll(float @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added(values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedFloatArraySet.from(values);
        }
        MutableFloatTreeSet builder = new MutableFloatTreeSet();
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedFloatArraySet(builder.toArray());
    }

    public float getFirst() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    public float getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)FloatArrays.joinTo((float[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull FloatConsumer action) {
        for (float e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory
    implements FloatCollectionFactory<MutableFloatTreeSet, ImmutableSortedFloatArraySet> {
        private Factory() {
        }

        public ImmutableSortedFloatArraySet empty() {
            return ImmutableSortedFloatArraySet.empty();
        }

        public MutableFloatTreeSet newBuilder() {
            return new MutableFloatTreeSet();
        }

        public ImmutableSortedFloatArraySet build(@NotNull MutableFloatTreeSet builder) {
            return builder.isEmpty() ? ImmutableSortedFloatArraySet.empty() : new ImmutableSortedFloatArraySet(builder.toArray());
        }

        public void addToBuilder(@NotNull MutableFloatTreeSet builder, float value) {
            builder.add(value);
        }

        public MutableFloatTreeSet mergeBuilder(@NotNull MutableFloatTreeSet builder1, @NotNull MutableFloatTreeSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

