/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableIntSet;
import kala.collection.mutable.primitive.MutableIntTreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableSortedIntArraySet
extends AbstractImmutableIntSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final ImmutableSortedIntArraySet EMPTY = new ImmutableSortedIntArraySet(IntArrays.EMPTY);
    final int[] elements;

    ImmutableSortedIntArraySet(int[] elements) {
        this.elements = elements;
    }

    @NotNull
    public static IntCollectionFactory<?, ImmutableSortedIntArraySet> factory() {
        return FACTORY;
    }

    @Contract
    @NotNull
    public static ImmutableSortedIntArraySet empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableSortedIntArraySet of() {
        return ImmutableSortedIntArraySet.empty();
    }

    @NotNull
    public static ImmutableSortedIntArraySet of(int value1) {
        return new ImmutableSortedIntArraySet(new int[]{value1});
    }

    @NotNull
    public static ImmutableSortedIntArraySet of(int value1, int value2) {
        int c = Integer.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedIntArraySet(new int[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedIntArraySet(new int[]{value2, value1});
        }
        return new ImmutableSortedIntArraySet(new int[]{value1});
    }

    @NotNull
    public static ImmutableSortedIntArraySet of(int value1, int value2, int value3) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedIntArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedIntArraySet of(int value1, int value2, int value3, int value4) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedIntArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedIntArraySet of(int value1, int value2, int value3, int value4, int value5) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedIntArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedIntArraySet of(int ... values) {
        return ImmutableSortedIntArraySet.from(values);
    }

    @NotNull
    public static ImmutableSortedIntArraySet from(int @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedIntArraySet.empty();
        }
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.addAll(values);
        return new ImmutableSortedIntArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedIntArraySet from(@NotNull IntTraversable values) {
        return ImmutableSortedIntArraySet.from(values.iterator());
    }

    @NotNull
    public static ImmutableSortedIntArraySet from(@NotNull IntIterator it) {
        if (!it.hasNext()) {
            return ImmutableSortedIntArraySet.empty();
        }
        MutableIntTreeSet s = new MutableIntTreeSet();
        while (it.hasNext()) {
            s.add(it.nextInt());
        }
        return new ImmutableSortedIntArraySet(s.toArray());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedIntArraySet";
    }

    @NotNull
    public IntCollectionFactory<?, ImmutableSortedIntArraySet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public IntIterator iterator() {
        return IntArrays.iterator((int[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedIntArraySet added(int value) {
        int size = this.elements.length;
        if (size == 0) {
            return new ImmutableSortedIntArraySet(new int[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        int[] newElements = new int[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedIntArraySet(newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedIntArraySet(newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedIntArraySet(newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedIntArraySet addedAll(@NotNull IntTraversable values) {
        IntIterator it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        int[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedIntArraySet.from(values);
        }
        MutableIntTreeSet builder = new MutableIntTreeSet();
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedIntArraySet(builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedIntArraySet addedAll(int @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added(values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedIntArraySet.from(values);
        }
        MutableIntTreeSet builder = new MutableIntTreeSet();
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedIntArraySet(builder.toArray());
    }

    public int getFirst() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    public int getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)IntArrays.joinTo((int[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull IntConsumer action) {
        for (int e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory
    implements IntCollectionFactory<MutableIntTreeSet, ImmutableSortedIntArraySet> {
        private Factory() {
        }

        public ImmutableSortedIntArraySet empty() {
            return ImmutableSortedIntArraySet.empty();
        }

        public MutableIntTreeSet newBuilder() {
            return new MutableIntTreeSet();
        }

        public ImmutableSortedIntArraySet build(@NotNull MutableIntTreeSet builder) {
            return builder.isEmpty() ? ImmutableSortedIntArraySet.empty() : new ImmutableSortedIntArraySet(builder.toArray());
        }

        public void addToBuilder(@NotNull MutableIntTreeSet builder, int value) {
            builder.add(value);
        }

        public MutableIntTreeSet mergeBuilder(@NotNull MutableIntTreeSet builder1, @NotNull MutableIntTreeSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

