/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.LongConsumer;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableLongSet;
import kala.collection.mutable.primitive.MutableLongTreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableSortedLongArraySet
extends AbstractImmutableLongSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final ImmutableSortedLongArraySet EMPTY = new ImmutableSortedLongArraySet(LongArrays.EMPTY);
    final long[] elements;

    ImmutableSortedLongArraySet(long[] elements) {
        this.elements = elements;
    }

    @NotNull
    public static LongCollectionFactory<?, ImmutableSortedLongArraySet> factory() {
        return FACTORY;
    }

    @Contract
    @NotNull
    public static ImmutableSortedLongArraySet empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableSortedLongArraySet of() {
        return ImmutableSortedLongArraySet.empty();
    }

    @NotNull
    public static ImmutableSortedLongArraySet of(long value1) {
        return new ImmutableSortedLongArraySet(new long[]{value1});
    }

    @NotNull
    public static ImmutableSortedLongArraySet of(long value1, long value2) {
        int c = Long.compare(value1, value2);
        if (c < 0) {
            return new ImmutableSortedLongArraySet(new long[]{value1, value2});
        }
        if (c > 0) {
            return new ImmutableSortedLongArraySet(new long[]{value2, value1});
        }
        return new ImmutableSortedLongArraySet(new long[]{value1});
    }

    @NotNull
    public static ImmutableSortedLongArraySet of(long value1, long value2, long value3) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return new ImmutableSortedLongArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedLongArraySet of(long value1, long value2, long value3, long value4) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return new ImmutableSortedLongArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedLongArraySet of(long value1, long value2, long value3, long value4, long value5) {
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return new ImmutableSortedLongArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedLongArraySet of(long ... values) {
        return ImmutableSortedLongArraySet.from(values);
    }

    @NotNull
    public static ImmutableSortedLongArraySet from(long @NotNull [] values) {
        if (values.length == 0) {
            return ImmutableSortedLongArraySet.empty();
        }
        MutableLongTreeSet s = new MutableLongTreeSet();
        s.addAll(values);
        return new ImmutableSortedLongArraySet(s.toArray());
    }

    @NotNull
    public static ImmutableSortedLongArraySet from(@NotNull LongTraversable values) {
        return ImmutableSortedLongArraySet.from(values.iterator());
    }

    @NotNull
    public static ImmutableSortedLongArraySet from(@NotNull LongIterator it) {
        if (!it.hasNext()) {
            return ImmutableSortedLongArraySet.empty();
        }
        MutableLongTreeSet s = new MutableLongTreeSet();
        while (it.hasNext()) {
            s.add(it.nextLong());
        }
        return new ImmutableSortedLongArraySet(s.toArray());
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableSortedLongArraySet";
    }

    @NotNull
    public LongCollectionFactory<?, ImmutableSortedLongArraySet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public LongIterator iterator() {
        return LongArrays.iterator((long[])this.elements);
    }

    public int size() {
        return this.elements.length;
    }

    public int knownSize() {
        return this.size();
    }

    @Override
    @NotNull
    public ImmutableSortedLongArraySet added(long value) {
        int size = this.elements.length;
        if (size == 0) {
            return new ImmutableSortedLongArraySet(new long[]{value});
        }
        int idx = Arrays.binarySearch(this.elements, value);
        if (idx >= 0) {
            return this;
        }
        idx = -idx - 1;
        long[] newElements = new long[size + 1];
        if (idx == 0) {
            System.arraycopy(this.elements, 0, newElements, 1, size);
            newElements[0] = value;
            return new ImmutableSortedLongArraySet(newElements);
        }
        if (idx == size) {
            System.arraycopy(this.elements, 0, newElements, 0, size);
            newElements[size] = value;
            return new ImmutableSortedLongArraySet(newElements);
        }
        System.arraycopy(this.elements, 0, newElements, 0, idx);
        System.arraycopy(this.elements, idx, newElements, idx + 1, size - idx);
        newElements[idx] = value;
        return new ImmutableSortedLongArraySet(newElements);
    }

    @Override
    @NotNull
    public ImmutableSortedLongArraySet addedAll(@NotNull LongTraversable values) {
        LongIterator it = values.iterator();
        if (!it.hasNext()) {
            return this;
        }
        long[] elements = this.elements;
        if (elements.length == 0) {
            return ImmutableSortedLongArraySet.from(values);
        }
        MutableLongTreeSet builder = new MutableLongTreeSet();
        builder.addAll(elements);
        builder.addAll(values);
        if (builder.size() == elements.length) {
            return this;
        }
        return new ImmutableSortedLongArraySet(builder.toArray());
    }

    @Override
    @NotNull
    public ImmutableSortedLongArraySet addedAll(long @NotNull [] values) {
        int arrayLength = values.length;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayLength == 1) {
            return this.added(values[0]);
        }
        int size = this.elements.length;
        if (size == 0) {
            return ImmutableSortedLongArraySet.from(values);
        }
        MutableLongTreeSet builder = new MutableLongTreeSet();
        builder.addAll(this.elements);
        builder.addAll(values);
        return new ImmutableSortedLongArraySet(builder.toArray());
    }

    public long getFirst() {
        if (this.elements.length == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[0];
    }

    public long getLast() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return (A)LongArrays.joinTo((long[])this.elements, buffer, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix);
    }

    public void forEach(@NotNull LongConsumer action) {
        for (long e : this.elements) {
            action.accept(e);
        }
    }

    private static final class Factory
    implements LongCollectionFactory<MutableLongTreeSet, ImmutableSortedLongArraySet> {
        private Factory() {
        }

        public ImmutableSortedLongArraySet empty() {
            return ImmutableSortedLongArraySet.empty();
        }

        public MutableLongTreeSet newBuilder() {
            return new MutableLongTreeSet();
        }

        public ImmutableSortedLongArraySet build(@NotNull MutableLongTreeSet builder) {
            return builder.isEmpty() ? ImmutableSortedLongArraySet.empty() : new ImmutableSortedLongArraySet(builder.toArray());
        }

        public void addToBuilder(@NotNull MutableLongTreeSet builder, long value) {
            builder.add(value);
        }

        public MutableLongTreeSet mergeBuilder(@NotNull MutableLongTreeSet builder1, @NotNull MutableLongTreeSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

