/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.mutable.primitive.MutableBooleanArrayList;
import kala.collection.mutable.primitive.MutableBooleanSeq;
import kala.collection.primitive.BooleanArraySeq;
import kala.function.BooleanUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableBooleanArray
extends BooleanArraySeq
implements MutableBooleanSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableBooleanArray EMPTY = new MutableBooleanArray(BooleanArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableBooleanArray(boolean @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static BooleanCollectionFactory<?, MutableBooleanArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanArray create(int size) {
        return new MutableBooleanArray(new boolean[size]);
    }

    @NotNull
    public static MutableBooleanArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableBooleanArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanArray of(boolean value1) {
        return new MutableBooleanArray(new boolean[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableBooleanArray of(boolean value1, boolean value2) {
        return new MutableBooleanArray(new boolean[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableBooleanArray of(boolean value1, boolean value2, boolean value3) {
        return new MutableBooleanArray(new boolean[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableBooleanArray of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return new MutableBooleanArray(new boolean[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableBooleanArray of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return new MutableBooleanArray(new boolean[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableBooleanArray of(boolean ... values) {
        return values.length != 0 ? new MutableBooleanArray(values) : MutableBooleanArray.empty();
    }

    @NotNull
    public static MutableBooleanArray from(boolean @NotNull [] values) {
        return values.length != 0 ? new MutableBooleanArray((boolean[])values.clone()) : MutableBooleanArray.empty();
    }

    @NotNull
    public static MutableBooleanArray from(@NotNull BooleanTraversable values) {
        return values.isNotEmpty() ? new MutableBooleanArray(values.toArray()) : MutableBooleanArray.empty();
    }

    @NotNull
    public static MutableBooleanArray from(@NotNull BooleanIterator it) {
        if (!it.hasNext()) {
            return MutableBooleanArray.empty();
        }
        return new MutableBooleanArray(it.toArray());
    }

    @NotNull
    public static MutableBooleanArray fill(int n, boolean value) {
        if (n <= 0) {
            return MutableBooleanArray.empty();
        }
        boolean[] ans = new boolean[n];
        if (value) {
            Arrays.fill(ans, value);
        }
        return new MutableBooleanArray(ans);
    }

    @NotNull
    public static MutableBooleanArray fill(int n, @NotNull BooleanSupplier supplier) {
        if (n <= 0) {
            return MutableBooleanArray.empty();
        }
        boolean[] ans = new boolean[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsBoolean();
        }
        return new MutableBooleanArray(ans);
    }

    @NotNull
    public static MutableBooleanArray wrap(boolean @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableBooleanArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public BooleanCollectionFactory<?, MutableBooleanArray> iterableFactory() {
        return MutableBooleanArray.factory();
    }

    @NotNull
    public MutableBooleanArray clone() {
        return new MutableBooleanArray((boolean[])this.elements.clone());
    }

    public boolean @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, boolean newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull BooleanUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsBoolean(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        BooleanArrays.sort((boolean[])this.elements);
    }

    private static final class Factory
    implements BooleanCollectionFactory<MutableBooleanArrayList, MutableBooleanArray> {
        Factory() {
        }

        public MutableBooleanArray from(boolean @NotNull [] values) {
            return MutableBooleanArray.from(values);
        }

        public MutableBooleanArray from(@NotNull BooleanTraversable values) {
            return MutableBooleanArray.from(values);
        }

        @NotNull
        public MutableBooleanArray from(@NotNull BooleanIterator it) {
            return MutableBooleanArray.from(it);
        }

        public MutableBooleanArray fill(int n, boolean value) {
            return MutableBooleanArray.fill(n, value);
        }

        public MutableBooleanArray fill(int n, @NotNull BooleanSupplier supplier) {
            return MutableBooleanArray.fill(n, supplier);
        }

        public MutableBooleanArrayList newBuilder() {
            return new MutableBooleanArrayList();
        }

        public void addToBuilder(@NotNull MutableBooleanArrayList builder, boolean value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableBooleanArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableBooleanArrayList mergeBuilder(@NotNull MutableBooleanArrayList builder1, @NotNull MutableBooleanArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableBooleanArray build(@NotNull MutableBooleanArrayList builder) {
            return new MutableBooleanArray(builder.toArray());
        }
    }
}

