/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.Conditions;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanArray;
import kala.collection.mutable.primitive.AbstractMutableBooleanList;
import kala.collection.mutable.primitive.AbstractMutableBooleanListFactory;
import kala.collection.mutable.primitive.MutableBooleanListIterator;
import kala.collection.primitive.AbstractBooleanSeqIterator;
import kala.collection.primitive.BooleanSeqLike;
import kala.collection.primitive.IndexedBooleanSeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableBooleanArrayList
extends AbstractMutableBooleanList
implements IndexedBooleanSeq,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final boolean[] DEFAULT_EMPTY_ARRAY = new boolean[0];
    boolean @NotNull [] elements;
    int size;

    private MutableBooleanArrayList(boolean @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableBooleanArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableBooleanArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? BooleanArrays.EMPTY : new boolean[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static BooleanCollectionFactory<?, MutableBooleanArrayList> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableBooleanArrayList create() {
        return new MutableBooleanArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanArrayList create(int initialCapacity) {
        return new MutableBooleanArrayList(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableBooleanArrayList of() {
        return new MutableBooleanArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanArrayList of(boolean value1) {
        boolean[] arr = new boolean[10];
        arr[0] = value1;
        return new MutableBooleanArrayList(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableBooleanArrayList of(boolean value1, boolean value2) {
        boolean[] arr = new boolean[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableBooleanArrayList(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableBooleanArrayList of(boolean value1, boolean value2, boolean value3) {
        boolean[] arr = new boolean[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableBooleanArrayList(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableBooleanArrayList of(boolean value1, boolean value2, boolean value3, boolean value4) {
        boolean[] arr = new boolean[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableBooleanArrayList(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableBooleanArrayList of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        boolean[] arr = new boolean[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableBooleanArrayList(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanArrayList of(boolean ... values) {
        return MutableBooleanArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanArrayList from(boolean @NotNull [] values) {
        int length = values.length;
        return length != 0 ? new MutableBooleanArrayList(Arrays.copyOf(values, Integer.max(10, values.length)), length) : new MutableBooleanArrayList();
    }

    @NotNull
    public static MutableBooleanArrayList from(@NotNull BooleanTraversable values) {
        MutableBooleanArrayList buffer = new MutableBooleanArrayList();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static MutableBooleanArrayList from(@NotNull BooleanIterator it) {
        MutableBooleanArrayList buffer = new MutableBooleanArrayList();
        while (it.hasNext()) {
            buffer.append(it.nextBoolean());
        }
        return buffer;
    }

    @NotNull
    public static MutableBooleanArrayList fill(int n, boolean value) {
        if (n <= 0) {
            return new MutableBooleanArrayList();
        }
        boolean[] arr = new boolean[Integer.max(10, n)];
        if (value) {
            Arrays.fill(arr, 0, n, true);
        }
        return new MutableBooleanArrayList(arr, n);
    }

    @NotNull
    public static MutableBooleanArrayList fill(int n, @NotNull BooleanSupplier supplier) {
        if (n <= 0) {
            return new MutableBooleanArrayList();
        }
        boolean[] arr = new boolean[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.getAsBoolean();
        }
        return new MutableBooleanArrayList(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        boolean[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private boolean[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new boolean[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new boolean[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    boolean @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableBooleanArrayList";
    }

    @NotNull
    public BooleanCollectionFactory<?, MutableBooleanArrayList> iterableFactory() {
        return MutableBooleanArrayList.factory();
    }

    @Override
    @NotNull
    public BooleanIterator iterator() {
        return BooleanArrays.iterator((boolean[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public BooleanIterator iterator(int beginIndex) {
        return BooleanArrays.iterator((boolean[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableBooleanListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    public MutableBooleanArrayList clone() {
        return new MutableBooleanArrayList(this.elements.length == 0 ? this.elements : (boolean[])this.elements.clone(), this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public boolean get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return this.elements[index];
    }

    @Override
    public void set(int index, boolean newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(boolean value) {
        boolean[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull BooleanTraversable values) {
        BooleanSeqLike seq;
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof BooleanSeqLike && (seq = (BooleanSeqLike)values).supportsFastRandomAccess()) {
            int s = seq.size();
            if (s == 0) {
                return;
            }
            boolean[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        boolean[] cv = values.toArray();
        if (cv.length == 0) {
            return;
        }
        boolean[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(boolean value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull BooleanTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = values.knownSize();
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        values.forEach(this::append);
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        boolean[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public void sort() {
        BooleanArrays.sort((boolean[])this.elements, (int)0, (int)this.size);
    }

    @Override
    public void insert(int index, boolean value) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        if (index == this.size) {
            this.append(value);
            return;
        }
        if (this.elements.length == this.size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull BooleanTraversable values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        int otherSize = values.size();
        boolean[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        BooleanIterator it = values.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.nextBoolean();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, boolean @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        boolean[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? DEFAULT_EMPTY_ARRAY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        boolean oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = false;
        this.size = newSize;
        return oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        this.size = n;
    }

    public int copyToArray(int srcPos, boolean @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public boolean @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @NotNull
    public ImmutableBooleanArray toImmutableArray() {
        return this.size == 0 ? ImmutableBooleanArray.empty() : ImmutableBooleanArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeBoolean(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        boolean[] elements = size == 0 ? DEFAULT_EMPTY_ARRAY : new boolean[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readBoolean();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory
    extends AbstractMutableBooleanListFactory<MutableBooleanArrayList> {
        private Factory() {
        }

        public MutableBooleanArrayList newBuilder() {
            return new MutableBooleanArrayList();
        }

        public void sizeHint(@NotNull MutableBooleanArrayList buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableBooleanArrayList from(boolean @NotNull [] values) {
            return MutableBooleanArrayList.from(values);
        }

        public MutableBooleanArrayList from(@NotNull BooleanTraversable values) {
            return MutableBooleanArrayList.from(values);
        }

        public MutableBooleanArrayList from(@NotNull BooleanIterator it) {
            return MutableBooleanArrayList.from(it);
        }

        public MutableBooleanArrayList fill(int n, boolean value) {
            return MutableBooleanArrayList.fill(n, value);
        }

        public MutableBooleanArrayList fill(int n, @NotNull BooleanSupplier supplier) {
            return MutableBooleanArrayList.fill(n, supplier);
        }
    }

    private static final class SeqItr
    extends AbstractBooleanSeqIterator
    implements MutableBooleanListIterator {
        private final MutableBooleanArrayList seq;
        private int lastReturned = -1;

        SeqItr(MutableBooleanArrayList seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public boolean nextBoolean() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                boolean res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public boolean previousBoolean() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                boolean res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(boolean e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(boolean e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

