/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.BooleanGrowable;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.mutable.primitive.MutableBooleanArrayList;
import kala.collection.mutable.primitive.MutableBooleanListIterator;
import kala.collection.mutable.primitive.MutableBooleanSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.BooleanArraySeq;
import kala.collection.primitive.BooleanSeq;
import kala.collection.primitive.internal.BooleanSeqIterators;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableBooleanList
extends MutablePrimitiveList<Boolean>,
MutableBooleanSeq,
BooleanGrowable {
    @NotNull
    public static BooleanCollectionFactory<?, MutableBooleanList> factory() {
        return BooleanCollectionFactory.narrow(MutableBooleanArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableBooleanList create() {
        return MutableBooleanArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableBooleanList of() {
        return MutableBooleanArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanList of(boolean value1) {
        return MutableBooleanArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableBooleanList of(boolean value1, boolean value2) {
        return MutableBooleanArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableBooleanList of(boolean value1, boolean value2, boolean value3) {
        return MutableBooleanArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableBooleanList of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return MutableBooleanArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableBooleanList of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return MutableBooleanArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanList of(boolean ... values) {
        return MutableBooleanArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanList from(boolean @NotNull [] values) {
        return MutableBooleanArrayList.from(values);
    }

    @NotNull
    public static MutableBooleanList from(@NotNull BooleanTraversable values) {
        return MutableBooleanArrayList.from(values);
    }

    @NotNull
    public static MutableBooleanList from(@NotNull BooleanIterator it) {
        return MutableBooleanArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableBooleanList";
    }

    @NotNull
    default public BooleanCollectionFactory<?, ? extends MutableBooleanList> iterableFactory() {
        return MutableBooleanList.factory();
    }

    @Override
    @NotNull
    default public MutableBooleanListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableBooleanListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new BooleanSeqIterators.DefaultMutableBooleanListIterator<MutableBooleanList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) boolean var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) boolean @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(BooleanArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) BooleanTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (boolean e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(boolean value) {
        this.append(value);
    }

    default public void plusAssign(boolean @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull BooleanTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(boolean var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) boolean @NotNull [] values) {
        this.prependAll(BooleanArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) BooleanTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            boolean[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof BooleanSeq && ((BooleanSeq)values).supportsFastRandomAccess()) {
            BooleanSeq seq = (BooleanSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        boolean[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) boolean var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) boolean @NotNull [] values) {
        this.insertAll(index, BooleanArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) BooleanTraversable values) {
        boolean[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (boolean e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public boolean removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public boolean removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Boolean removeFirstOrNull() {
        return this.isEmpty() ? null : Boolean.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public BooleanOption removeFirstOption() {
        return this.isEmpty() ? BooleanOption.none() : BooleanOption.some((boolean)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public boolean removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public boolean removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : Boolean.valueOf(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    @NotNull
    default public BooleanOption removeLastOption() {
        int size = this.size();
        return size == 0 ? BooleanOption.none() : BooleanOption.some((boolean)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull BooleanPredicate predicate) {
        MutableBooleanListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            boolean value = it.nextBoolean();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    default public boolean removeAll(@NotNull BooleanPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull BooleanPredicate predicate) {
        MutableBooleanListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            boolean value = it.nextBoolean();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    @Contract(mutates="this")
    default public boolean retainAll(@NotNull BooleanPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableBooleanListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextBoolean();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableBooleanListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextBoolean();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull BooleanPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull BooleanPredicate predicate) {
        this.removeAll(predicate);
    }
}

