/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kala.Conditions;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.mutable.primitive.MutableBooleanArray;
import kala.collection.mutable.primitive.MutableBooleanCollection;
import kala.collection.mutable.primitive.MutableBooleanSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.BooleanSeq;
import kala.collection.primitive.internal.BooleanSeqIterators;
import kala.function.BooleanUnaryOperator;
import kala.function.IndexedBooleanUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableBooleanSeq
extends MutablePrimitiveSeq<Boolean>,
BooleanSeq,
MutableBooleanCollection {
    @NotNull
    public static BooleanCollectionFactory<?, MutableBooleanSeq> factory() {
        return BooleanCollectionFactory.narrow(MutableBooleanArray.factory());
    }

    @NotNull
    public static MutableBooleanSeq of() {
        return MutableBooleanArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanSeq of(boolean value1) {
        return MutableBooleanArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableBooleanSeq of(boolean value1, boolean value2) {
        return MutableBooleanArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableBooleanSeq of(boolean value1, boolean value2, boolean value3) {
        return MutableBooleanArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableBooleanSeq of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return MutableBooleanArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableBooleanSeq of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return MutableBooleanArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableBooleanSeq of(boolean ... values) {
        return MutableBooleanArray.of(values);
    }

    @NotNull
    public static MutableBooleanSeq from(boolean @NotNull [] values) {
        return MutableBooleanArray.from(values);
    }

    @NotNull
    public static MutableBooleanSeq from(@NotNull BooleanTraversable values) {
        return MutableBooleanArray.from(values);
    }

    @NotNull
    public static MutableBooleanSeq from(@NotNull BooleanIterator it) {
        return MutableBooleanArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableBooleanSeq";
    }

    @NotNull
    default public BooleanCollectionFactory<?, ? extends MutableBooleanSeq> iterableFactory() {
        return MutableBooleanSeq.factory();
    }

    @Override
    @NotNull
    default public MutableBooleanSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableBooleanSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new BooleanSeqIterators.DefaultMutableBooleanSeqIterator<MutableBooleanSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, boolean var2);

    default public void swap(int index1, int index2) {
        boolean old1 = this.get(index1);
        boolean old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull BooleanUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsBoolean(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedBooleanUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsBoolean(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        int i;
        int size = this.size();
        int trueCount = this.count(it -> it);
        int falseCount = size - trueCount;
        if (trueCount == 0 || falseCount == 0) {
            return;
        }
        for (i = 0; i < falseCount; ++i) {
            this.set(i, false);
        }
        for (i = falseCount; i < size; ++i) {
            this.set(i, true);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            boolean[] arr = this.toArray();
            BooleanArrays.shuffle((boolean[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

