/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.mutable.primitive.MutableByteArrayList;
import kala.collection.mutable.primitive.MutableByteSeq;
import kala.collection.primitive.ByteArraySeq;
import kala.function.ByteSupplier;
import kala.function.ByteUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableByteArray
extends ByteArraySeq
implements MutableByteSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableByteArray EMPTY = new MutableByteArray(ByteArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableByteArray(byte @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static ByteCollectionFactory<?, MutableByteArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteArray create(int size) {
        return new MutableByteArray(new byte[size]);
    }

    @NotNull
    public static MutableByteArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableByteArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteArray of(byte value1) {
        return new MutableByteArray(new byte[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableByteArray of(byte value1, byte value2) {
        return new MutableByteArray(new byte[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableByteArray of(byte value1, byte value2, byte value3) {
        return new MutableByteArray(new byte[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableByteArray of(byte value1, byte value2, byte value3, byte value4) {
        return new MutableByteArray(new byte[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableByteArray of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return new MutableByteArray(new byte[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableByteArray of(byte ... values) {
        return values.length != 0 ? new MutableByteArray(values) : MutableByteArray.empty();
    }

    @NotNull
    public static MutableByteArray from(byte @NotNull [] values) {
        return values.length != 0 ? new MutableByteArray((byte[])values.clone()) : MutableByteArray.empty();
    }

    @NotNull
    public static MutableByteArray from(@NotNull ByteTraversable values) {
        return values.isNotEmpty() ? new MutableByteArray(values.toArray()) : MutableByteArray.empty();
    }

    @NotNull
    public static MutableByteArray from(@NotNull ByteIterator it) {
        if (!it.hasNext()) {
            return MutableByteArray.empty();
        }
        return new MutableByteArray(it.toArray());
    }

    @NotNull
    public static MutableByteArray fill(int n, byte value) {
        if (n <= 0) {
            return MutableByteArray.empty();
        }
        byte[] ans = new byte[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new MutableByteArray(ans);
    }

    @NotNull
    public static MutableByteArray fill(int n, @NotNull ByteSupplier supplier) {
        if (n <= 0) {
            return MutableByteArray.empty();
        }
        byte[] ans = new byte[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsByte();
        }
        return new MutableByteArray(ans);
    }

    @NotNull
    public static MutableByteArray wrap(byte @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableByteArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public ByteCollectionFactory<?, MutableByteArray> iterableFactory() {
        return MutableByteArray.factory();
    }

    @NotNull
    public MutableByteArray clone() {
        return new MutableByteArray((byte[])this.elements.clone());
    }

    public byte @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, byte newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull ByteUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsByte(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        ByteArrays.sort((byte[])this.elements);
    }

    private static final class Factory
    implements ByteCollectionFactory<MutableByteArrayList, MutableByteArray> {
        Factory() {
        }

        public MutableByteArray from(byte @NotNull [] values) {
            return MutableByteArray.from(values);
        }

        public MutableByteArray from(@NotNull ByteTraversable values) {
            return MutableByteArray.from(values);
        }

        @NotNull
        public MutableByteArray from(@NotNull ByteIterator it) {
            return MutableByteArray.from(it);
        }

        public MutableByteArray fill(int n, byte value) {
            return MutableByteArray.fill(n, value);
        }

        public MutableByteArray fill(int n, @NotNull ByteSupplier supplier) {
            return MutableByteArray.fill(n, supplier);
        }

        public MutableByteArrayList newBuilder() {
            return new MutableByteArrayList();
        }

        public void addToBuilder(@NotNull MutableByteArrayList builder, byte value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableByteArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableByteArrayList mergeBuilder(@NotNull MutableByteArrayList builder1, @NotNull MutableByteArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableByteArray build(@NotNull MutableByteArrayList builder) {
            return new MutableByteArray(builder.toArray());
        }
    }
}

