/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.ByteGrowable;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.mutable.primitive.MutableByteArrayList;
import kala.collection.mutable.primitive.MutableByteListIterator;
import kala.collection.mutable.primitive.MutableByteSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.ByteArraySeq;
import kala.collection.primitive.ByteSeq;
import kala.collection.primitive.internal.ByteSeqIterators;
import kala.control.primitive.ByteOption;
import kala.function.BytePredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableByteList
extends MutablePrimitiveList<Byte>,
MutableByteSeq,
ByteGrowable {
    @NotNull
    public static ByteCollectionFactory<?, MutableByteList> factory() {
        return ByteCollectionFactory.narrow(MutableByteArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableByteList create() {
        return MutableByteArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableByteList of() {
        return MutableByteArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteList of(byte value1) {
        return MutableByteArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableByteList of(byte value1, byte value2) {
        return MutableByteArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableByteList of(byte value1, byte value2, byte value3) {
        return MutableByteArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableByteList of(byte value1, byte value2, byte value3, byte value4) {
        return MutableByteArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableByteList of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return MutableByteArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteList of(byte ... values) {
        return MutableByteArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteList from(byte @NotNull [] values) {
        return MutableByteArrayList.from(values);
    }

    @NotNull
    public static MutableByteList from(@NotNull ByteTraversable values) {
        return MutableByteArrayList.from(values);
    }

    @NotNull
    public static MutableByteList from(@NotNull ByteIterator it) {
        return MutableByteArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableByteList";
    }

    @NotNull
    default public ByteCollectionFactory<?, ? extends MutableByteList> iterableFactory() {
        return MutableByteList.factory();
    }

    @Override
    @NotNull
    default public MutableByteListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableByteListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new ByteSeqIterators.DefaultMutableByteListIterator<MutableByteList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) byte var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) byte @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(ByteArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ByteTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (byte e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(byte value) {
        this.append(value);
    }

    default public void plusAssign(byte @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull ByteTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(byte var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) byte @NotNull [] values) {
        this.prependAll(ByteArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ByteTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            byte[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof ByteSeq && ((ByteSeq)values).supportsFastRandomAccess()) {
            ByteSeq seq = (ByteSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        byte[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) byte var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) byte @NotNull [] values) {
        this.insertAll(index, ByteArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ByteTraversable values) {
        byte[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (byte e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public byte removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public byte removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Byte removeFirstOrNull() {
        return this.isEmpty() ? null : Byte.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public ByteOption removeFirstOption() {
        return this.isEmpty() ? ByteOption.none() : ByteOption.some((byte)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public byte removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public byte removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : Byte.valueOf(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    @NotNull
    default public ByteOption removeLastOption() {
        int size = this.size();
        return size == 0 ? ByteOption.none() : ByteOption.some((byte)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull BytePredicate predicate) {
        MutableByteListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            byte value = it.nextByte();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    default public boolean removeAll(@NotNull BytePredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull BytePredicate predicate) {
        MutableByteListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            byte value = it.nextByte();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    @Contract(mutates="this")
    default public boolean retainAll(@NotNull BytePredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableByteListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextByte();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableByteListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextByte();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull BytePredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull BytePredicate predicate) {
        this.removeAll(predicate);
    }
}

