/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import kala.collection.base.primitive.ByteGrowable;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.mutable.primitive.DefaultMutableByteSet;
import kala.collection.mutable.primitive.MutableByteCollection;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.ByteArraySeq;
import kala.collection.primitive.ByteSet;
import kala.function.BytePredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableByteSet
extends MutablePrimitiveSet<Byte>,
ByteSet,
MutableByteCollection,
ByteGrowable {
    @Contract(pure=true)
    @NotNull
    public static ByteCollectionFactory<?, MutableByteSet> factory() {
        return ByteCollectionFactory.narrow(DefaultMutableByteSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableByteSet create() {
        return DefaultMutableByteSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableByteSet of() {
        return DefaultMutableByteSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteSet of(byte value1) {
        return DefaultMutableByteSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableByteSet of(byte value1, byte value2) {
        return DefaultMutableByteSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableByteSet of(byte value1, byte value2, byte value3) {
        return DefaultMutableByteSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableByteSet of(byte value1, byte value2, byte value3, byte value4) {
        return DefaultMutableByteSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableByteSet of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return DefaultMutableByteSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteSet of(byte ... values) {
        return DefaultMutableByteSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteSet from(byte @NotNull [] values) {
        return DefaultMutableByteSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteSet from(@NotNull ByteTraversable values) {
        return DefaultMutableByteSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteSet from(@NotNull ByteIterator it) {
        return DefaultMutableByteSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableByteSet";
    }

    @NotNull
    default public ByteCollectionFactory<?, ? extends MutableByteSet> iterableFactory() {
        return MutableByteSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) byte var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) byte @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(ByteArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ByteTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        ByteIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextByte())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(byte value) {
        this.add(value);
    }

    default public void plusAssign(byte @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull ByteTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(byte var1);

    @Contract(mutates="this")
    default public boolean removeAll(byte @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(ByteArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull ByteTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        ByteIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextByte())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        byte[] arr = this.toArray();
        int oldSize = arr.length;
        for (byte e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean removeAll(@NotNull BytePredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainAll(byte @NotNull [] values) {
        return this.retainAll(ByteArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull ByteTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        byte[] arr = this.toArray();
        int oldSize = arr.length;
        ByteIterator it = this.iterator();
        while (it.hasNext()) {
            byte v = it.nextByte();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull BytePredicate predicate) {
        Objects.requireNonNull(predicate);
        byte[] arr = this.toArray();
        int oldSize = arr.length;
        for (byte e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean retainAll(@NotNull BytePredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull BytePredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull BytePredicate predicate) {
        this.removeAll(predicate);
    }
}

