/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.mutable.primitive.MutableCharArrayList;
import kala.collection.mutable.primitive.MutableCharSeq;
import kala.collection.primitive.CharArraySeq;
import kala.function.CharSupplier;
import kala.function.CharUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableCharArray
extends CharArraySeq
implements MutableCharSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableCharArray EMPTY = new MutableCharArray(CharArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableCharArray(char @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static CharCollectionFactory<?, MutableCharArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharArray create(int size) {
        return new MutableCharArray(new char[size]);
    }

    @NotNull
    public static MutableCharArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableCharArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharArray of(char value1) {
        return new MutableCharArray(new char[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableCharArray of(char value1, char value2) {
        return new MutableCharArray(new char[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableCharArray of(char value1, char value2, char value3) {
        return new MutableCharArray(new char[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableCharArray of(char value1, char value2, char value3, char value4) {
        return new MutableCharArray(new char[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableCharArray of(char value1, char value2, char value3, char value4, char value5) {
        return new MutableCharArray(new char[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableCharArray of(char ... values) {
        return values.length != 0 ? new MutableCharArray(values) : MutableCharArray.empty();
    }

    @NotNull
    public static MutableCharArray from(char @NotNull [] values) {
        return values.length != 0 ? new MutableCharArray((char[])values.clone()) : MutableCharArray.empty();
    }

    @NotNull
    public static MutableCharArray from(@NotNull CharTraversable values) {
        return values.isNotEmpty() ? new MutableCharArray(values.toArray()) : MutableCharArray.empty();
    }

    @NotNull
    public static MutableCharArray from(@NotNull CharIterator it) {
        if (!it.hasNext()) {
            return MutableCharArray.empty();
        }
        return new MutableCharArray(it.toArray());
    }

    @NotNull
    public static MutableCharArray fill(int n, char value) {
        if (n <= 0) {
            return MutableCharArray.empty();
        }
        char[] ans = new char[n];
        if (value != '\u0000') {
            Arrays.fill(ans, value);
        }
        return new MutableCharArray(ans);
    }

    @NotNull
    public static MutableCharArray fill(int n, @NotNull CharSupplier supplier) {
        if (n <= 0) {
            return MutableCharArray.empty();
        }
        char[] ans = new char[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsChar();
        }
        return new MutableCharArray(ans);
    }

    @NotNull
    public static MutableCharArray wrap(char @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableCharArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public CharCollectionFactory<?, MutableCharArray> iterableFactory() {
        return MutableCharArray.factory();
    }

    @NotNull
    public MutableCharArray clone() {
        return new MutableCharArray((char[])this.elements.clone());
    }

    public char @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, char newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull CharUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsChar(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        CharArrays.sort((char[])this.elements);
    }

    private static final class Factory
    implements CharCollectionFactory<MutableCharArrayList, MutableCharArray> {
        Factory() {
        }

        public MutableCharArray from(char @NotNull [] values) {
            return MutableCharArray.from(values);
        }

        public MutableCharArray from(@NotNull CharTraversable values) {
            return MutableCharArray.from(values);
        }

        @NotNull
        public MutableCharArray from(@NotNull CharIterator it) {
            return MutableCharArray.from(it);
        }

        public MutableCharArray fill(int n, char value) {
            return MutableCharArray.fill(n, value);
        }

        public MutableCharArray fill(int n, @NotNull CharSupplier supplier) {
            return MutableCharArray.fill(n, supplier);
        }

        public MutableCharArrayList newBuilder() {
            return new MutableCharArrayList();
        }

        public void addToBuilder(@NotNull MutableCharArrayList builder, char value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableCharArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableCharArrayList mergeBuilder(@NotNull MutableCharArrayList builder1, @NotNull MutableCharArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableCharArray build(@NotNull MutableCharArrayList builder) {
            return new MutableCharArray(builder.toArray());
        }
    }
}

