/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.AnySet;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableCharSetFactory;
import kala.collection.mutable.primitive.MutableCharSet;
import kala.collection.primitive.CharSet;
import kala.collection.primitive.internal.tree.CharRedBlackTree;
import kala.function.CharConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableCharTreeSet
extends CharRedBlackTree<Node>
implements MutableCharSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory FACTORY = new Factory();

    @NotNull
    public static CharCollectionFactory<?, MutableCharTreeSet> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet create() {
        return new MutableCharTreeSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of() {
        return new MutableCharTreeSet();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of(char value1) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of(char value1, char value2) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of(char value1, char value2, char value3) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of(char value1, char value2, char value3, char value4) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of(char value1, char value2, char value3, char value4, char value5) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet of(char ... values) {
        return MutableCharTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet from(char @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet from(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        MutableCharTreeSet s = new MutableCharTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableCharTreeSet from(@NotNull CharIterator it) {
        MutableCharTreeSet s = new MutableCharTreeSet();
        while (it.hasNext()) {
            s.add(it.nextChar());
        }
        return s;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableCharTreeSet";
    }

    @NotNull
    public CharCollectionFactory<?, MutableCharTreeSet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public CharIterator iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? CharIterator.empty() : new Itr(firstNode);
    }

    @NotNull
    public MutableCharTreeSet clone() {
        return MutableCharTreeSet.from(this);
    }

    @Override
    public boolean add(char value) {
        int c;
        Node parent;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node(value, null);
            this.size = 1;
            return true;
        }
        do {
            parent = node;
            c = Character.compare(value, node.getValue());
            if (c < 0) {
                node = (Node)node.left;
                continue;
            }
            if (c > 0) {
                node = (Node)node.right;
                continue;
            }
            return false;
        } while (node != null);
        Node n = new Node(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(char value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(char value) {
        return this.getNode(value) != null;
    }

    public char getFirst() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public char getLast() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public char @NotNull [] toArray() {
        int size = this.size;
        char[] res = new char[size];
        if (size == 0) {
            return res;
        }
        CharIterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.nextChar();
        }
        return res;
    }

    public int hashCode() {
        return CharSet.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && CharSet.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull CharConsumer action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readChar());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        this.forEachUnchecked(out::writeChar);
    }

    private static final class Factory
    extends AbstractMutableCharSetFactory<MutableCharTreeSet> {
        private Factory() {
        }

        public MutableCharTreeSet newBuilder() {
            return new MutableCharTreeSet();
        }
    }

    static final class Node
    extends CharRedBlackTree.Node<Node> {
        Node(char value, Node parent) {
            super(value, parent);
        }

        void setValue(char newValue) {
            this.key = newValue;
        }

        char getValue() {
            return this.key;
        }

        public String toString() {
            return String.format("MutableCharTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", Character.valueOf(this.key), this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr
    extends AbstractCharIterator {
        private Node node;

        Itr(Node node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public char nextChar() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

