/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.DoubleSupplier;
import kala.Conditions;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.ImmutableDoubleArray;
import kala.collection.mutable.primitive.AbstractMutableDoubleList;
import kala.collection.mutable.primitive.AbstractMutableDoubleListFactory;
import kala.collection.mutable.primitive.MutableDoubleListIterator;
import kala.collection.primitive.AbstractDoubleSeqIterator;
import kala.collection.primitive.DoubleSeqLike;
import kala.collection.primitive.IndexedDoubleSeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableDoubleArrayList
extends AbstractMutableDoubleList
implements IndexedDoubleSeq,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    double @NotNull [] elements;
    int size;

    private MutableDoubleArrayList(double @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableDoubleArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableDoubleArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? DoubleArrays.EMPTY : new double[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static DoubleCollectionFactory<?, MutableDoubleArrayList> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableDoubleArrayList create() {
        return new MutableDoubleArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleArrayList create(int initialCapacity) {
        return new MutableDoubleArrayList(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableDoubleArrayList of() {
        return new MutableDoubleArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleArrayList of(double value1) {
        double[] arr = new double[10];
        arr[0] = value1;
        return new MutableDoubleArrayList(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableDoubleArrayList of(double value1, double value2) {
        double[] arr = new double[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableDoubleArrayList(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableDoubleArrayList of(double value1, double value2, double value3) {
        double[] arr = new double[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableDoubleArrayList(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableDoubleArrayList of(double value1, double value2, double value3, double value4) {
        double[] arr = new double[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableDoubleArrayList(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableDoubleArrayList of(double value1, double value2, double value3, double value4, double value5) {
        double[] arr = new double[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableDoubleArrayList(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleArrayList of(double ... values) {
        return MutableDoubleArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleArrayList from(double @NotNull [] values) {
        int length = values.length;
        return length != 0 ? new MutableDoubleArrayList(Arrays.copyOf(values, Integer.max(10, values.length)), length) : new MutableDoubleArrayList();
    }

    @NotNull
    public static MutableDoubleArrayList from(@NotNull DoubleTraversable values) {
        MutableDoubleArrayList buffer = new MutableDoubleArrayList();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static MutableDoubleArrayList from(@NotNull DoubleIterator it) {
        MutableDoubleArrayList buffer = new MutableDoubleArrayList();
        while (it.hasNext()) {
            buffer.append(it.nextDouble());
        }
        return buffer;
    }

    @NotNull
    public static MutableDoubleArrayList fill(int n, double value) {
        if (n <= 0) {
            return new MutableDoubleArrayList();
        }
        double[] arr = new double[Integer.max(10, n)];
        if (value != 0.0) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableDoubleArrayList(arr, n);
    }

    @NotNull
    public static MutableDoubleArrayList fill(int n, @NotNull DoubleSupplier supplier) {
        if (n <= 0) {
            return new MutableDoubleArrayList();
        }
        double[] arr = new double[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.getAsDouble();
        }
        return new MutableDoubleArrayList(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        double[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private double[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new double[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new double[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    double @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableDoubleArrayList";
    }

    @NotNull
    public DoubleCollectionFactory<?, MutableDoubleArrayList> iterableFactory() {
        return MutableDoubleArrayList.factory();
    }

    @Override
    @NotNull
    public DoubleIterator iterator() {
        return DoubleArrays.iterator((double[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public DoubleIterator iterator(int beginIndex) {
        return DoubleArrays.iterator((double[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableDoubleListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    @NotNull
    public Spliterator.OfDouble spliterator() {
        return Arrays.spliterator(this.elements, 0, this.size);
    }

    public MutableDoubleArrayList clone() {
        return new MutableDoubleArrayList(this.elements.length == 0 ? this.elements : (double[])this.elements.clone(), this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public double get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return this.elements[index];
    }

    @Override
    public void set(int index, double newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(double value) {
        double[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull DoubleTraversable values) {
        DoubleSeqLike seq;
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof DoubleSeqLike && (seq = (DoubleSeqLike)values).supportsFastRandomAccess()) {
            int s = seq.size();
            if (s == 0) {
                return;
            }
            double[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        double[] cv = values.toArray();
        if (cv.length == 0) {
            return;
        }
        double[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(double value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = values.knownSize();
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        values.forEach(this::append);
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        double[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, double value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public void sort() {
        DoubleArrays.sort((double[])this.elements, (int)0, (int)this.size);
    }

    @Override
    public void insert(int index, double value) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        if (index == this.size) {
            this.append(value);
            return;
        }
        if (this.elements.length == this.size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        int otherSize = values.size();
        double[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        DoubleIterator it = values.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.nextDouble();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, double @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        double[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? DEFAULT_EMPTY_ARRAY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public double removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        double oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = 0.0;
        this.size = newSize;
        return oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        this.size = n;
    }

    public int copyToArray(int srcPos, double @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public double @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @NotNull
    public ImmutableDoubleArray toImmutableArray() {
        return this.size == 0 ? ImmutableDoubleArray.empty() : ImmutableDoubleArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeDouble(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        double[] elements = size == 0 ? DEFAULT_EMPTY_ARRAY : new double[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readDouble();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory
    extends AbstractMutableDoubleListFactory<MutableDoubleArrayList> {
        private Factory() {
        }

        public MutableDoubleArrayList newBuilder() {
            return new MutableDoubleArrayList();
        }

        public void sizeHint(@NotNull MutableDoubleArrayList buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableDoubleArrayList from(double @NotNull [] values) {
            return MutableDoubleArrayList.from(values);
        }

        public MutableDoubleArrayList from(@NotNull DoubleTraversable values) {
            return MutableDoubleArrayList.from(values);
        }

        public MutableDoubleArrayList from(@NotNull DoubleIterator it) {
            return MutableDoubleArrayList.from(it);
        }

        public MutableDoubleArrayList fill(int n, double value) {
            return MutableDoubleArrayList.fill(n, value);
        }

        public MutableDoubleArrayList fill(int n, @NotNull DoubleSupplier supplier) {
            return MutableDoubleArrayList.fill(n, supplier);
        }
    }

    private static final class SeqItr
    extends AbstractDoubleSeqIterator
    implements MutableDoubleListIterator {
        private final MutableDoubleArrayList seq;
        private int lastReturned = -1;

        SeqItr(MutableDoubleArrayList seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public double nextDouble() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                double res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public double previousDouble() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                double res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(double e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(double e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

