/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import kala.collection.AnySet;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableDoubleSetFactory;
import kala.collection.mutable.primitive.MutableDoubleSet;
import kala.collection.primitive.DoubleSet;
import kala.collection.primitive.internal.tree.DoubleRedBlackTree;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableDoubleTreeSet
extends DoubleRedBlackTree<Node>
implements MutableDoubleSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory FACTORY = new Factory();

    @NotNull
    public static DoubleCollectionFactory<?, MutableDoubleTreeSet> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet create() {
        return new MutableDoubleTreeSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of() {
        return new MutableDoubleTreeSet();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of(double value1) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of(double value1, double value2) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of(double value1, double value2, double value3) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of(double value1, double value2, double value3, double value4) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of(double value1, double value2, double value3, double value4, double value5) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet of(double ... values) {
        return MutableDoubleTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet from(double @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet from(@NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableDoubleTreeSet from(@NotNull DoubleIterator it) {
        MutableDoubleTreeSet s = new MutableDoubleTreeSet();
        while (it.hasNext()) {
            s.add(it.nextDouble());
        }
        return s;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableDoubleTreeSet";
    }

    @NotNull
    public DoubleCollectionFactory<?, MutableDoubleTreeSet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public DoubleIterator iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? DoubleIterator.empty() : new Itr(firstNode);
    }

    @NotNull
    public MutableDoubleTreeSet clone() {
        return MutableDoubleTreeSet.from(this);
    }

    @Override
    public boolean add(double value) {
        int c;
        Node parent;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node(value, null);
            this.size = 1;
            return true;
        }
        do {
            parent = node;
            c = Double.compare(value, node.getValue());
            if (c < 0) {
                node = (Node)node.left;
                continue;
            }
            if (c > 0) {
                node = (Node)node.right;
                continue;
            }
            return false;
        } while (node != null);
        Node n = new Node(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(double value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(double value) {
        return this.getNode(value) != null;
    }

    public double getFirst() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public double getLast() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public double @NotNull [] toArray() {
        int size = this.size;
        double[] res = new double[size];
        if (size == 0) {
            return res;
        }
        DoubleIterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.nextDouble();
        }
        return res;
    }

    public int hashCode() {
        return DoubleSet.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && DoubleSet.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull DoubleConsumer action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readDouble());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        this.forEachUnchecked(out::writeDouble);
    }

    private static final class Factory
    extends AbstractMutableDoubleSetFactory<MutableDoubleTreeSet> {
        private Factory() {
        }

        public MutableDoubleTreeSet newBuilder() {
            return new MutableDoubleTreeSet();
        }
    }

    static final class Node
    extends DoubleRedBlackTree.Node<Node> {
        Node(double value, Node parent) {
            super(value, parent);
        }

        void setValue(double newValue) {
            this.key = newValue;
        }

        double getValue() {
            return this.key;
        }

        public String toString() {
            return String.format("MutableDoubleTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", this.key, this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr
    extends AbstractDoubleIterator {
        private Node node;

        Itr(Node node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public double nextDouble() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

