/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kala.Conditions;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.mutable.primitive.MutableFloatArray;
import kala.collection.mutable.primitive.MutableFloatCollection;
import kala.collection.mutable.primitive.MutableFloatSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.FloatSeq;
import kala.collection.primitive.internal.FloatSeqIterators;
import kala.function.FloatUnaryOperator;
import kala.function.IndexedFloatUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableFloatSeq
extends MutablePrimitiveSeq<Float>,
FloatSeq,
MutableFloatCollection {
    @NotNull
    public static FloatCollectionFactory<?, MutableFloatSeq> factory() {
        return FloatCollectionFactory.narrow(MutableFloatArray.factory());
    }

    @NotNull
    public static MutableFloatSeq of() {
        return MutableFloatArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatSeq of(float value1) {
        return MutableFloatArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableFloatSeq of(float value1, float value2) {
        return MutableFloatArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableFloatSeq of(float value1, float value2, float value3) {
        return MutableFloatArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableFloatSeq of(float value1, float value2, float value3, float value4) {
        return MutableFloatArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableFloatSeq of(float value1, float value2, float value3, float value4, float value5) {
        return MutableFloatArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableFloatSeq of(float ... values) {
        return MutableFloatArray.of(values);
    }

    @NotNull
    public static MutableFloatSeq from(float @NotNull [] values) {
        return MutableFloatArray.from(values);
    }

    @NotNull
    public static MutableFloatSeq from(@NotNull FloatTraversable values) {
        return MutableFloatArray.from(values);
    }

    @NotNull
    public static MutableFloatSeq from(@NotNull FloatIterator it) {
        return MutableFloatArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableFloatSeq";
    }

    @NotNull
    default public FloatCollectionFactory<?, ? extends MutableFloatSeq> iterableFactory() {
        return MutableFloatSeq.factory();
    }

    @Override
    @NotNull
    default public MutableFloatSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableFloatSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new FloatSeqIterators.DefaultMutableFloatSeqIterator<MutableFloatSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, float var2);

    default public void swap(int index1, int index2) {
        float old1 = this.get(index1);
        float old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull FloatUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsFloat(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedFloatUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsFloat(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        float[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            float[] arr = this.toArray();
            FloatArrays.shuffle((float[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

