/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import kala.collection.base.primitive.FloatGrowable;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.mutable.primitive.MutableFloatCollection;
import kala.collection.mutable.primitive.MutableFloatTreeSet;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.FloatArraySeq;
import kala.collection.primitive.FloatSet;
import kala.function.FloatPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableFloatSet
extends MutablePrimitiveSet<Float>,
FloatSet,
MutableFloatCollection,
FloatGrowable {
    @Contract(pure=true)
    @NotNull
    public static FloatCollectionFactory<?, MutableFloatSet> factory() {
        return FloatCollectionFactory.narrow(MutableFloatTreeSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableFloatSet create() {
        return MutableFloatTreeSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableFloatSet of() {
        return MutableFloatTreeSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatSet of(float value1) {
        return MutableFloatTreeSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableFloatSet of(float value1, float value2) {
        return MutableFloatTreeSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableFloatSet of(float value1, float value2, float value3) {
        return MutableFloatTreeSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableFloatSet of(float value1, float value2, float value3, float value4) {
        return MutableFloatTreeSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableFloatSet of(float value1, float value2, float value3, float value4, float value5) {
        return MutableFloatTreeSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatSet of(float ... values) {
        return MutableFloatTreeSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatSet from(float @NotNull [] values) {
        return MutableFloatTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatSet from(@NotNull FloatTraversable values) {
        return MutableFloatTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableFloatSet from(@NotNull FloatIterator it) {
        return MutableFloatTreeSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableFloatSet";
    }

    @NotNull
    default public FloatCollectionFactory<?, ? extends MutableFloatSet> iterableFactory() {
        return MutableFloatSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) float var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) float @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(FloatArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) FloatTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        FloatIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextFloat())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(float value) {
        this.add(value);
    }

    default public void plusAssign(float @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull FloatTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(float var1);

    @Contract(mutates="this")
    default public boolean removeAll(float @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(FloatArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull FloatTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        FloatIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextFloat())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        float[] arr = this.toArray();
        int oldSize = arr.length;
        for (float e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean removeAll(@NotNull FloatPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainAll(float @NotNull [] values) {
        return this.retainAll(FloatArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull FloatTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        float[] arr = this.toArray();
        int oldSize = arr.length;
        FloatIterator it = this.iterator();
        while (it.hasNext()) {
            float v = it.nextFloat();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        float[] arr = this.toArray();
        int oldSize = arr.length;
        for (float e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean retainAll(@NotNull FloatPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull FloatPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull FloatPredicate predicate) {
        this.removeAll(predicate);
    }
}

