/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.mutable.primitive.MutableIntSeq;
import kala.collection.primitive.IntArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableIntArray
extends IntArraySeq
implements MutableIntSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableIntArray EMPTY = new MutableIntArray(IntArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableIntArray(int @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static IntCollectionFactory<?, MutableIntArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntArray create(int size) {
        return new MutableIntArray(new int[size]);
    }

    @NotNull
    public static MutableIntArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableIntArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntArray of(int value1) {
        return new MutableIntArray(new int[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableIntArray of(int value1, int value2) {
        return new MutableIntArray(new int[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableIntArray of(int value1, int value2, int value3) {
        return new MutableIntArray(new int[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableIntArray of(int value1, int value2, int value3, int value4) {
        return new MutableIntArray(new int[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableIntArray of(int value1, int value2, int value3, int value4, int value5) {
        return new MutableIntArray(new int[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableIntArray of(int ... values) {
        return values.length != 0 ? new MutableIntArray(values) : MutableIntArray.empty();
    }

    @NotNull
    public static MutableIntArray from(int @NotNull [] values) {
        return values.length != 0 ? new MutableIntArray((int[])values.clone()) : MutableIntArray.empty();
    }

    @NotNull
    public static MutableIntArray from(@NotNull IntTraversable values) {
        return values.isNotEmpty() ? new MutableIntArray(values.toArray()) : MutableIntArray.empty();
    }

    @NotNull
    public static MutableIntArray from(@NotNull IntIterator it) {
        if (!it.hasNext()) {
            return MutableIntArray.empty();
        }
        return new MutableIntArray(it.toArray());
    }

    @NotNull
    public static MutableIntArray fill(int n, int value) {
        if (n <= 0) {
            return MutableIntArray.empty();
        }
        int[] ans = new int[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new MutableIntArray(ans);
    }

    @NotNull
    public static MutableIntArray fill(int n, @NotNull IntSupplier supplier) {
        if (n <= 0) {
            return MutableIntArray.empty();
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsInt();
        }
        return new MutableIntArray(ans);
    }

    @NotNull
    public static MutableIntArray wrap(int @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableIntArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public IntCollectionFactory<?, MutableIntArray> iterableFactory() {
        return MutableIntArray.factory();
    }

    @NotNull
    public MutableIntArray clone() {
        return new MutableIntArray((int[])this.elements.clone());
    }

    public int @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, int newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull IntUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsInt(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        IntArrays.sort((int[])this.elements);
    }

    private static final class Factory
    implements IntCollectionFactory<MutableIntArrayList, MutableIntArray> {
        Factory() {
        }

        public MutableIntArray from(int @NotNull [] values) {
            return MutableIntArray.from(values);
        }

        public MutableIntArray from(@NotNull IntTraversable values) {
            return MutableIntArray.from(values);
        }

        @NotNull
        public MutableIntArray from(@NotNull IntIterator it) {
            return MutableIntArray.from(it);
        }

        public MutableIntArray fill(int n, int value) {
            return MutableIntArray.fill(n, value);
        }

        public MutableIntArray fill(int n, @NotNull IntSupplier supplier) {
            return MutableIntArray.fill(n, supplier);
        }

        public MutableIntArrayList newBuilder() {
            return new MutableIntArrayList();
        }

        public void addToBuilder(@NotNull MutableIntArrayList builder, int value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableIntArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableIntArrayList mergeBuilder(@NotNull MutableIntArrayList builder1, @NotNull MutableIntArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableIntArray build(@NotNull MutableIntArrayList builder) {
            return new MutableIntArray(builder.toArray());
        }
    }
}

