/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntSupplier;
import kala.Conditions;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.ImmutableIntArray;
import kala.collection.mutable.primitive.AbstractMutableIntList;
import kala.collection.mutable.primitive.AbstractMutableIntListFactory;
import kala.collection.mutable.primitive.MutableIntListIterator;
import kala.collection.primitive.AbstractIntSeqIterator;
import kala.collection.primitive.IndexedIntSeq;
import kala.collection.primitive.IntSeqLike;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableIntArrayList
extends AbstractMutableIntList
implements IndexedIntSeq,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    int @NotNull [] elements;
    int size;

    private MutableIntArrayList(int @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableIntArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableIntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? IntArrays.EMPTY : new int[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static IntCollectionFactory<?, MutableIntArrayList> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableIntArrayList create() {
        return new MutableIntArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntArrayList create(int initialCapacity) {
        return new MutableIntArrayList(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableIntArrayList of() {
        return new MutableIntArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntArrayList of(int value1) {
        int[] arr = new int[10];
        arr[0] = value1;
        return new MutableIntArrayList(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableIntArrayList of(int value1, int value2) {
        int[] arr = new int[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableIntArrayList(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableIntArrayList of(int value1, int value2, int value3) {
        int[] arr = new int[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableIntArrayList(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableIntArrayList of(int value1, int value2, int value3, int value4) {
        int[] arr = new int[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableIntArrayList(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableIntArrayList of(int value1, int value2, int value3, int value4, int value5) {
        int[] arr = new int[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableIntArrayList(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntArrayList of(int ... values) {
        return MutableIntArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntArrayList from(int @NotNull [] values) {
        int length = values.length;
        return length != 0 ? new MutableIntArrayList(Arrays.copyOf(values, Integer.max(10, values.length)), length) : new MutableIntArrayList();
    }

    @NotNull
    public static MutableIntArrayList from(@NotNull IntTraversable values) {
        MutableIntArrayList buffer = new MutableIntArrayList();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static MutableIntArrayList from(@NotNull IntIterator it) {
        MutableIntArrayList buffer = new MutableIntArrayList();
        while (it.hasNext()) {
            buffer.append(it.nextInt());
        }
        return buffer;
    }

    @NotNull
    public static MutableIntArrayList fill(int n, int value) {
        if (n <= 0) {
            return new MutableIntArrayList();
        }
        int[] arr = new int[Integer.max(10, n)];
        if (value != 0) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableIntArrayList(arr, n);
    }

    @NotNull
    public static MutableIntArrayList fill(int n, @NotNull IntSupplier supplier) {
        if (n <= 0) {
            return new MutableIntArrayList();
        }
        int[] arr = new int[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.getAsInt();
        }
        return new MutableIntArrayList(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        int[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private int[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new int[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new int[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    int @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableIntArrayList";
    }

    @NotNull
    public IntCollectionFactory<?, MutableIntArrayList> iterableFactory() {
        return MutableIntArrayList.factory();
    }

    @Override
    @NotNull
    public IntIterator iterator() {
        return IntArrays.iterator((int[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public IntIterator iterator(int beginIndex) {
        return IntArrays.iterator((int[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableIntListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    @NotNull
    public Spliterator.OfInt spliterator() {
        return Arrays.spliterator(this.elements, 0, this.size);
    }

    public MutableIntArrayList clone() {
        return new MutableIntArrayList(this.elements.length == 0 ? this.elements : (int[])this.elements.clone(), this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return this.elements[index];
    }

    @Override
    public void set(int index, int newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(int value) {
        int[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull IntTraversable values) {
        IntSeqLike seq;
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof IntSeqLike && (seq = (IntSeqLike)values).supportsFastRandomAccess()) {
            int s = seq.size();
            if (s == 0) {
                return;
            }
            int[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        int[] cv = values.toArray();
        if (cv.length == 0) {
            return;
        }
        int[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(int value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = values.knownSize();
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        values.forEach(this::append);
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        int[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, int value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public void sort() {
        IntArrays.sort((int[])this.elements, (int)0, (int)this.size);
    }

    @Override
    public void insert(int index, int value) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        if (index == this.size) {
            this.append(value);
            return;
        }
        if (this.elements.length == this.size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        int otherSize = values.size();
        int[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        IntIterator it = values.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.nextInt();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, int @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        int[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? DEFAULT_EMPTY_ARRAY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        int oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = 0;
        this.size = newSize;
        return oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        this.size = n;
    }

    public int copyToArray(int srcPos, int @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public int @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @NotNull
    public ImmutableIntArray toImmutableArray() {
        return this.size == 0 ? ImmutableIntArray.empty() : ImmutableIntArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeInt(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int[] elements = size == 0 ? DEFAULT_EMPTY_ARRAY : new int[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readInt();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory
    extends AbstractMutableIntListFactory<MutableIntArrayList> {
        private Factory() {
        }

        public MutableIntArrayList newBuilder() {
            return new MutableIntArrayList();
        }

        public void sizeHint(@NotNull MutableIntArrayList buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableIntArrayList from(int @NotNull [] values) {
            return MutableIntArrayList.from(values);
        }

        public MutableIntArrayList from(@NotNull IntTraversable values) {
            return MutableIntArrayList.from(values);
        }

        public MutableIntArrayList from(@NotNull IntIterator it) {
            return MutableIntArrayList.from(it);
        }

        public MutableIntArrayList fill(int n, int value) {
            return MutableIntArrayList.fill(n, value);
        }

        public MutableIntArrayList fill(int n, @NotNull IntSupplier supplier) {
            return MutableIntArrayList.fill(n, supplier);
        }
    }

    private static final class SeqItr
    extends AbstractIntSeqIterator
    implements MutableIntListIterator {
        private final MutableIntArrayList seq;
        private int lastReturned = -1;

        SeqItr(MutableIntArrayList seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public int nextInt() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                int res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public int previousInt() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                int res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(int e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(int e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

